/* ================================================================
||   Program: create_components.sql
||   Data:       2013-07-25
||   Książka:    Oracle Database 12c. Programowanie w języku PL/SQL
||   Rozdział:   9
||   Autor:  Michael McLaughlin
|| ----------------------------------------------------------------
||   Zawartość:
||   ---------
||   Ten skrypt ilustruje pakiety.
|| ================================================================*/

-- Po zakończeniu debugowania umieść w komentarzu.
SET ECHO ON
SET FEEDBACK ON
SET PAGESIZE 49999
SET SERVEROUTPUT ON SIZE 1000000

-- Specyfikacja pakietu.
CREATE OR REPLACE PACKAGE components IS

  -- Deklaracja komponentów pakietu.
  PROCEDURE set (value IN OUT VARCHAR2);
  FUNCTION get RETURN VARCHAR2;

END components;
/

-- Ciało pakietu.
CREATE OR REPLACE PACKAGE BODY components IS
  -- Deklaracja zmiennych współużytkowanych z poziomu pakietu.
  key NUMBER := 0;
  variable VARCHAR2(20) := 'Wartość początkowa';

  -- Definicja funkcji i procedury dostępnych tylko w pakiecie.
  FUNCTION locked RETURN BOOLEAN IS
    key NUMBER := 0;
  BEGIN
    IF components.key = key THEN
      components.key := 1;
      RETURN FALSE;
    ELSE
      RETURN TRUE;
    END IF;
  END locked;

  PROCEDURE unlock IS
    key NUMBER := 1;
  BEGIN
    IF components.key = key THEN
      components.key := 0;              -- Zerowanie klucza.
      variable := 'Wartość początkowa'; -- Przywracanie początkowej wartości zmiennej współużytkowanej.
    END IF;
  END unlock;

  -- Definicje publicznej funkcji i publicznej procedury.
  FUNCTION get RETURN VARCHAR2 IS
  BEGIN
    RETURN variable;
  END get;

  PROCEDURE set (value VARCHAR2) IS
  BEGIN
    IF NOT locked THEN
      variable := value;
      dbms_output.put_line('Nowa wartość do momentu zwolnienia blokady ['||get||'].');
      unlock;
    END IF;
  END set;

END components;
/

-- Instrukcje testowe.
VARIABLE current_content VARCHAR2(20)
CALL components.get() INTO :current_content;
SELECT :current_content FROM dual;
EXECUTE components.set('Nowa wartość');
CALL components.get() INTO :current_content;
SELECT :current_content FROM dual;
