/* ================================================================
||   Program: sql_collection.sql
||   Data:       2013-07-25
||   Ksika:    Oracle Database 12c. Programowanie w jzyku PL/SQL
||   Rozdzia:   6
||   Autor:  Michael McLaughlin
|| ----------------------------------------------------------------
||   Zawarto:
||   ---------
||   Ten skrypt ilustruje kolekcje: tabele zagniedone i tablice varray.
|| ================================================================*/

SET SERVEROUTPUT ON SIZE UNLIMITED

CREATE OR REPLACE
  TYPE sql_varray IS VARRAY(3) OF VARCHAR2(20) NOT NULL;
/

CREATE OR REPLACE
  TYPE sql_varying IS VARRAY(3) OF VARCHAR2(20) NOT NULL;
/

SELECT   column_value AS "Three Stooges"
FROM     TABLE(sql_varray('Moe','Larry','Curly'));

DECLARE
  lv_collection  SQL_VARRAY := sql_varray('Moe','Larry');
BEGIN
  /* Wywietlanie wartoci funkcji COUNT i LIMIT. */
  dbms_output.put_line(
    'Count ['||lv_collection.COUNT||']'||
    'Limit ['||lv_collection.LIMIT||']');
    
  /* Przydzielanie pamici na nowy element. */ 
  lv_collection.EXTEND;

  /* Wywietlanie wartoci funkcji COUNT i LIMIT. */
  dbms_output.put_line(
    'Count ['||lv_collection.COUNT||'] '||
    'Limit ['||lv_collection.LIMIT||']');
  
  /* Przypisywanie nowej wartoci. */
  lv_collection(lv_collection.COUNT) := 'Curly';

  /* Przechodzenie po wszystkich elementach kolekcji. */  
  FOR i IN 1..lv_collection.COUNT LOOP
    dbms_output.put_line(lv_collection(i));
  END LOOP;
END;
/

DECLARE
  lv_collection  SQL_VARYING := sql_varying('Moe','Larry','Shemp');
BEGIN
  /* Wywietlanie wartoci funkcji COUNT i LIMIT. */
  dbms_output.put_line(
    'Count ['||lv_collection.COUNT||']'||
    'Limit ['||lv_collection.LIMIT||']');
    
  /* Przydzielanie pamici na dodatkowy element. */ 
  lv_collection.EXTEND;

  /* Wywietlanie wartoci funkcji COUNT i LIMIT. */
  dbms_output.put_line(
    'Count ['||lv_collection.COUNT||']'||
    'Limit ['||lv_collection.LIMIT||']');
    
  /* Przypisywanie nowej wartoci. */
  lv_collection(lv_collection.COUNT) := 'Curly';

  /* Przechodzenie po wszystkich elementach kolekcji. */  
  FOR i IN 1..lv_collection.COUNT LOOP
    dbms_output.put_line(lv_collection(i));
  END LOOP;
END;
/

CREATE OR REPLACE
  TYPE sql_table IS TABLE OF VARCHAR2(20);
/

SELECT   column_value AS "Dnedain"
FROM     TABLE(sql_table('Aragorn','Faramir','Boromir'))
ORDER BY 1;

CREATE OR REPLACE FUNCTION add_element
( pv_table    SQL_TABLE
, pv_element  VARCHAR2 ) RETURN SQL_TABLE IS

  /* Deklaracja lokalnej tabeli zagniedonej. */
  lv_table    SQL_TABLE := sql_table();
BEGIN
  IF pv_table.EXISTS(1) THEN
    lv_table := pv_table;
  END IF;
  
  /* Sprawdzanie, czy element jest rny od null, przed jego dodaniem. */
  IF pv_element IS NOT NULL THEN
    /* Przydzielanie pamici i dodawanie elementu. */
    lv_table.EXTEND;
    lv_table(lv_table.COUNT) := pv_element;
  END IF;
  
  /* Zwracanie kolekcji z nowym elementem. */
  RETURN lv_table;
END;
/

DECLARE
  /* Deklaracja zmiennej o znaczcej nazwie (ale bez
     przedrostka lv_). */
  current  INTEGER := 1;
  
  /* Deklaracja lokalnej kolekcji. */
  lv_table    SQL_TABLE :=
                sql_table('Aragorn','Faramir','Boromir');
BEGIN
  /* Usuwanie pierwszego elementu kolekcji. */
  lv_table.DELETE(1);

  /* Ustawianie pocztkowego elementu. */
  current := lv_table.FIRST;
  
  /* Sprawdzanie, czy warto indeksu jest mniejsza lub rwna ostatniemu indeksowi. */  
  WHILE (current <= lv_table.LAST) LOOP
    /* Wywietlanie biecej wartoci. */
    dbms_output.put_line(
      'Warto ['||current||']['||lv_table(current)||']');

    /* Przechodzenie do nastpnego indeksu. */
    current := lv_table.NEXT(current);    
  END LOOP;
END;
/

DECLARE
  /* Deklaracja zmiennej lokalnej dla licznika. */
  lv_counter  INTEGER := 0;
  
  /* Deklaracja lokalnej tabeli zagniedonej. */
  lv_table    SQL_TABLE :=
                sql_table('Aragorn','Faramir','Boromir');
BEGIN
  /* Usuwanie pierwszego elementu kolekcji. */
  lv_table.DELETE(1);

  /* Sprawdzanie, czy warto indeksu jest mniejsza lub rwna ostatniemu indeksowi. */  
  WHILE (lv_counter <= lv_table.LAST) LOOP
    /* Zwikszanie wartoci licznika. */
    lv_counter := lv_counter + 1;    

    /* Sprawdzanie, czy indeks zwraca warto. */
    IF lv_table.EXISTS(lv_counter) THEN
      dbms_output.put_line(
        'Wartoci ['||lv_counter||']['||lv_table(lv_counter)||']');
    END IF; 
  END LOOP;
END;
/
  
SELECT   column_value AS "Dnedain"
FROM     TABLE(add_element(sql_table('Faramir','Boromir')
                          ,'Aragorn'))
ORDER BY 1;

SELECT   column_value AS "Dnedain"
FROM     TABLE(add_element(sql_table(),'Aragorn'))
ORDER BY 1;

SELECT   column_value AS "Dnedain"
FROM     TABLE(add_element(null,'Aragorn'))
ORDER BY 1;

SELECT   column_value AS "Dnedain"
FROM     TABLE(add_element(null,null))
ORDER BY 1;

CREATE OR REPLACE FUNCTION add_element
( pv_table    SQL_TABLE
, pv_element  VARCHAR2 ) RETURN SQL_TABLE IS

  /* Deklaracja lokalnej tabeli zagniedonej. */
  lv_table    SQL_TABLE := sql_table();
BEGIN

  /* Sprawdzanie, czy kolekcja jest zainicjowana. */
  IF pv_table IS NOT EMPTY THEN
    lv_table := pv_table;
  END IF;
  
  /* Sprawdzanie, czy element jest rny od null, przed jego dodaniem. */
  IF pv_element IS NOT NULL THEN
    /* Przydzielanie pamici i dodawanie elementu. */
    lv_table.EXTEND;
    lv_table(lv_table.COUNT) := pv_element;
  END IF;
  
  /* Zwracanie kolekcji z nowym elementem. */
  RETURN lv_table;
END;
/

SELECT   column_value AS "Dnedain"
FROM     TABLE(add_element(sql_table('Faramir','Boromir')
                          ,'Aragorn'))
ORDER BY 1;

SELECT   column_value AS "Dnedain"
FROM     TABLE(add_element(sql_table(),'Aragorn'))
ORDER BY 1;

SELECT   column_value AS "Dnedain"
FROM     TABLE(add_element(null,'Aragorn'))
ORDER BY 1;

SELECT   column_value AS "Dnedain"
FROM     TABLE(add_element(null,null))
ORDER BY 1;

DECLARE
  /* Definicja typu kolekcji (tabeli zagniedonej). */
  TYPE plsql_table IS TABLE OF VARCHAR2(20);

  /* Deklaracja lokalnej tabeli zagniedonej. */
  lv_table    PLSQL_TABLE :=
                plsql_table('Aragorn','Faramir','Boromir');
BEGIN
  /* Przejcie w ptli po kolekcji i wywietlenie wynikw. */
  FOR i IN lv_table.FIRST..lv_table.LAST LOOP
    dbms_output.put_line(lv_table(i));
  END LOOP;
END;
/

CREATE OR REPLACE PACKAGE type_library IS
  /* Definicja lokalnej tabeli zagniedonej. */
  TYPE plsql_table IS TABLE OF VARCHAR2(20);
END;
/

DECLARE
  /* Deklaracja lokalnej tabeli zagniedonej. */
  lv_table  TYPE_LIBRARY.PLSQL_TABLE :=
              type_library.plsql_table('Aragorn','Faramir','Boromir');
BEGIN
  /* Przejcie w ptli po kolekcji i wywietlenie wynikw. */
  FOR i IN lv_table.FIRST..lv_table.LAST LOOP
    dbms_output.put_line(lv_table(i));
  END LOOP;
END;
/

DROP TYPE people_table FORCE;
DROP TYPE people_object FORCE;
DROP TYPE prominent_table FORCE;
DROP TYPE prominent_object FORCE;

CREATE OR REPLACE
  TYPE prominent_object IS OBJECT
  ( name     VARCHAR2(20)
  , age      VARCHAR2(10));
/

CREATE OR REPLACE
  TYPE prominent_table IS TABLE OF prominent_object;
/

CREATE OR REPLACE
  TYPE people_object IS OBJECT
  ( race      VARCHAR2(10)
  , exemplar  PROMINENT_OBJECT);
/

CREATE OR REPLACE
  TYPE people_table IS TABLE OF people_object;
/

COLUMN EXEMPLAR FORMAT A40
SELECT  *
FROM    TABLE(
          SELECT CAST(COLLECT(
              people_object(
                 'Ludzie'
                , prominent_object('Aragorn','3rd Age')
              )
            ) AS people_table
          )
          FROM  dual);

COLUMN EXEMPLAR FORMAT A40
SELECT  o.race, n.name, n.age
FROM    TABLE(
          SELECT CAST(COLLECT(
              people_object(
                 'Ludzie'
                , prominent_object('Aragorn','3rd Age')
              )
            ) AS people_table
          )
          FROM  dual) o CROSS JOIN
        TABLE(
          SELECT CAST(COLLECT(exemplar) AS prominent_table)
          FROM dual) n;

          
SELECT  *
FROM    TABLE(
          people_table(
              people_object(
                 'Ludzie'
                , prominent_object('Aragorn','3rd Age'))
            , people_object(
                 'Elfy'
                , prominent_object('Legolas','3rd Age'))
            )) o CROSS JOIN
        TABLE(
          SELECT CAST(COLLECT(exemplar) AS prominent_table)
          FROM dual) n;

DECLARE
  /* Deklaracja rekordu. */
  TYPE tolkien_record IS RECORD
  ( race      VARCHAR2(10)
  , name      VARCHAR2(20)
  , age       VARCHAR2(10));

  /* Deklaracja tabeli zagniedonej z rekordami. */
  TYPE tolkien_plsql_table IS TABLE OF TOLKIEN_RECORD;
  
  /* Deklaracja zmiennych na rekord i tabel zagniedon. */
  lv_tolkien_record       TOLKIEN_RECORD;
  lv_tolkien_plsql_table  TOLKIEN_PLSQL_TABLE;
  
  /* Deklaracja tabeli zagniedonej. */
  lv_tolkien_table  PEOPLE_TABLE :=
                      people_table(
                        people_object(
                           'Ludzie'
                          , prominent_object('Aragorn','3rd Age'))
                      , people_object(
                           'Elfy'
                           , prominent_object('Legolas','3rd Age'))); 
BEGIN

  SELECT   o.race, n.name, n.age
  INTO     lv_tolkien_record
  FROM     TABLE(lv_tolkien_table) o CROSS JOIN
           TABLE(
             SELECT CAST(COLLECT(exemplar) AS prominent_table)
             FROM   dual) n
  WHERE    ROWNUM < 2;

  dbms_output.put_line(
    '['||lv_tolkien_record.race||'] '||
    '['||lv_tolkien_record.name||'] '||
    '['||lv_tolkien_record.age ||']');
END;
/

DECLARE
  /* Deklaracja rekordu. */
  TYPE tolkien_record IS RECORD
  ( race      VARCHAR2(10)
  , name      VARCHAR2(20)
  , age       VARCHAR2(10));

  /* Deklaracja tabeli zagniedonej z rekordami. */
  TYPE tolkien_plsql_table IS TABLE OF TOLKIEN_RECORD;
  
  /* Deklaracja zmiennych na rekord i tabel zagniedon. */
  lv_tolkien_record       TOLKIEN_RECORD;
  lv_tolkien_plsql_table  TOLKIEN_PLSQL_TABLE;
  
  /* Deklaracja tabeli zagniedonej. */
  lv_tolkien_table  PEOPLE_TABLE :=
                      people_table(
                        people_object(
                           'Ludzie'
                          , prominent_object('Aragorn','3rd Age'))
                      , people_object(
                           'Elfy'
                           , prominent_object('Legolas','3rd Age'))); 
BEGIN

  SELECT   o.race, n.name, n.age
  INTO     lv_tolkien_record
  FROM     TABLE(lv_tolkien_table) o CROSS JOIN
           TABLE(
             SELECT CAST(COLLECT(exemplar) AS prominent_table)
             FROM   dual) n
  FETCH    FIRST 1 ROWS ONLY;

  dbms_output.put_line(
    '['||lv_tolkien_record.race||'] '||
    '['||lv_tolkien_record.name||'] '||
    '['||lv_tolkien_record.age ||']');
END;
/


DECLARE
  /* Deklaracja rekordu. */
  TYPE tolkien_record IS RECORD
  ( race      VARCHAR2(10)
  , name      VARCHAR2(20)
  , age       VARCHAR2(10));
  
  /* Deklracja tabeli zagniedonej z rekordami. */
  TYPE tolkien_plsql_table IS TABLE OF TOLKIEN_RECORD;
  
  /* Deklaracja zmiennych na rekord i tabel zagniedon. */
  lv_tolkien_record       TOLKIEN_RECORD;
  lv_tolkien_plsql_table  TOLKIEN_PLSQL_TABLE;
  
  /* Deklaracja tabeli zagniedonej. */
  lv_tolkien_table  PEOPLE_TABLE :=
                      people_table(
                        people_object(
                           'Ludzie'
                          , prominent_object('Aragorn','3rd Age'))
                      , people_object(
                           'Elfy'
                           , prominent_object('Legolas','3rd Age'))); 
BEGIN
  /* Pobieranie masowe danych do lokalnej kolekcji jzyka PL//SQL. */
  SELECT   o.race, n.name, n.age
  BULK COLLECT INTO     lv_tolkien_plsql_table
  FROM     TABLE(lv_tolkien_table) o CROSS JOIN
           TABLE(
             SELECT CAST(COLLECT(exemplar) AS prominent_table)
             FROM   dual) n;
             
  /* Przejcie w ptli po zbiorze wynikw i ich wywietlenie. */           
  FOR i IN 1..lv_tolkien_plsql_table.COUNT LOOP
  dbms_output.put_line(
    '['||lv_tolkien_plsql_table(i).race||'] '||
    '['||lv_tolkien_plsql_table(i).name||'] '||
    '['||lv_tolkien_plsql_table(i).age ||']');
  END LOOP;
END;
/

 
DECLARE
  /* Deklaracja tabeli zagniedonej. */
  lv_tolkien  PEOPLE_TABLE :=
                 people_table(
                     people_object(
                        'Ludzie'
                       , prominent_object('Aragorn','3rd Age'))
                   , people_object(
                        'Elfy'
                       , prominent_object('Legolas','3rd Age'))); 
BEGIN
  /* Dodawanie nowego rekordu do kolekcji. */
  lv_tolkien.EXTEND;
  lv_tolkien(lv_tolkien.COUNT) := 
     people_object('Krasnaludy'
                  , prominent_object('Gimili','3rd Age'));

  /* Wczytywanie i wywietlanie wartoci w kolekcji. */
  FOR i IN lv_tolkien.FIRST..lv_tolkien.LAST LOOP
    dbms_output.put_line(
      lv_tolkien(i).race||': '||lv_tolkien(i).exemplar.name);
  END LOOP;  
END;
/

DROP TYPE people_table FORCE;
DROP TYPE people_object FORCE;
DROP TYPE prominent_table FORCE;
DROP TYPE prominent_object FORCE;

CREATE OR REPLACE
  TYPE prominent_object IS OBJECT
  ( name     VARCHAR2(20)
  , age      VARCHAR2(10));
/

CREATE OR REPLACE
  TYPE prominent_table IS TABLE OF prominent_object;
/

CREATE OR REPLACE
  TYPE people_object IS OBJECT
  ( race      VARCHAR2(10)
  , exemplar  PROMINENT_TABLE);
/

CREATE OR REPLACE
  TYPE people_table IS TABLE OF people_object;
/

DECLARE
  /* Deklaracja tabeli zagniedonej. */
  lv_tolkien  PEOPLE_TABLE :=
                 people_table(
                     people_object(
                        'Ludzie'
                       , prominent_table(
                             prominent_object('Aragorn','3rd Age')
                           , prominent_object('Boromir','3rd Age')
                           , prominent_object('Faramir','3rd Age')
                           , prominent_object('Eowyn','3rd Age')))
                   , people_object(
                        'Elfy'
                       , prominent_table(
                             prominent_object('Legolas','3rd Age')
                           , prominent_object('Arwen','3rd Age')))); 
BEGIN
  /* Dodawanie nowego rekordu do kolekcji. */
  lv_tolkien.EXTEND;
  lv_tolkien(lv_tolkien.COUNT) := 
     people_object('Krasnoludy'
                  , prominent_table(
                        prominent_object('Gimili','3rd Age')
                      , prominent_object('Gloin','3rd Age')));

  /* Wczytywanie i wywietlanie wartoci tabeli zagniedonej. */
  FOR i IN lv_tolkien.FIRST..lv_tolkien.LAST LOOP
    FOR j IN lv_tolkien(i).exemplar.FIRST..lv_tolkien(i).exemplar.LAST LOOP
      dbms_output.put_line(
        lv_tolkien(i).race||': '||lv_tolkien(i).exemplar(j).name);
    END LOOP;
  END LOOP;  
END;
/

COLUMN EXEMPLAR FORMAT A40
SELECT  *
FROM    TABLE(
          SELECT
            CAST(
              COLLECT(
                people_object(
                   'Ludzie'
                  , prominent_object('Aragorn','3rd Age')
                )
              ) AS people_table
            )
          FROM  dual) o
CROSS JOIN TABLE(CAST(COLLECT(exemplar) AS prominent_table)) n;