/* ================================================================
||   Program: collection_api.sql
||   Data:       2013-07-25
||   Książka:    Oracle Database 12c. Programowanie w języku PL/SQL
||   Rozdział:   6
||   Autor:  Michael McLaughlin
|| ----------------------------------------------------------------
||   Zawartość:
||   ---------
||   Ten skrypt ilustruje interfejs API kolekcji.
|| ================================================================*/

SET SERVEROUTPUT ON SIZE UNLIMITED

/* ================================================================
||  Metoda COUNT
|| ================================================================*/

DECLARE
  /* Definicja tabeli zagnieżdżonej. */
  TYPE x_table IS TABLE OF INTEGER;

  /* Deklaracja zainicjowanej tabeli zagnieżdżonej. */
  lv_table  NUMBER_TABLE := number_table(1,2,3,4,5);
BEGIN
  DBMS_OUTPUT.PUT_LINE('Ile elementów? ['||lv_table.COUNT||']');
END;
/

/* ================================================================
||  Metoda DELETE
|| ================================================================*/

DECLARE
  /* Deklaracja zmiennej o znaczącej nazwie. */ 
  current INTEGER;
  
  /* Definicja tabeli zagnieżdżonej. */
  TYPE x_table IS TABLE OF VARCHAR2(6);
  
  /* Deklaracja zainicjowanej tabeli zagnieżdżonej. */
  lv_table  X_TABLE := x_table('Jeden','Dwa','Trzy','Cztery','Pięć');
BEGIN
  /* Usuwanie elementu o indeksie 2. */
  lv_table.DELETE(2,2);
  
  /* Usuwanie elementów z przedziału od 4 do 5 włącznie. */
  lv_table.DELETE(4,5);

  /* Ustawianie początkowego indeksu. */  
  current := x.FIRST;

  /* Wczytywanie indeksów rosnąco. */  
  WHILE (current <= x.LAST) LOOP
    dbms_output.put_line(
      'Indeks ['||current||'] Wartość ['||x(current)||']');
    /* Przechodzenie do następnego indeksu. */
    current := x.NEXT(current);
  END LOOP;
END;
/

/* ================================================================
||  Metoda EXISTS
|| ================================================================*/

DECLARE
  /* Definicja tabeli zagnieżdżonej. */
  TYPE x_table IS TABLE OF VARCHAR2(10);
  
  /* Deklaracja licznika dla indeksu. */
  lv_index  NUMBER := 1;
  
  /* Deklaracja zmiennej lokalnej na kolekcję. */
  lv_table  X_TABLE := x_table();
BEGIN
  IF lv_table.EXISTS(lv_index) AND NOT lv_table.COUNT = 0 THEN
    dbms_output.put_line(lv_table(lv_index));
  END IF;
END;
/

DECLARE
  /* Definicja tabeli zagnieżdżonej. */
  TYPE x_table IS TABLE OF VARCHAR2(10);
  
  /* Deklaracja licznika dla indeksu. */
  lv_index  NUMBER := 1;
  
  /* Deklaracja zmiennej lokalnej na kolekcję. */
  lv_table  X_TABLE := x_table() := x_table('Coś');
BEGIN
  IF lv_table.EXISTS(lv_index) AND lv_table.COUNT > 0 THEN
    dbms_output.put_line(lv_table(lv_index));
  END IF;
END;
/

/* ================================================================
||  Metoda EXTEND
|| ================================================================*/

DECLARE
  /* Deklaracja zmiennej o znaczącej nazwie. */ 
  current INTEGER;
  
  /* Definicja tabeli zagnieżdżonej. */
  TYPE x_table IS TABLE OF VARCHAR2(6);
  
  /* Deklaracja zainicjowanej tabeli zagnieżdżonej. */
  lv_table  X_TABLE := x_table('Jeden');
BEGIN
  /* Zajmowanie dodatkowej pamięci. */
  lv_table.EXTEND;
  
  /* Przypisywanie wartości do ostatniego dodanego elementu. */
  lv_table(lv_table.COUNT) := 'Dwa';

  /* Ustawianie indeksu początkowego. */  
  current := lv_table.FIRST;

  /* Wczytywanie indeksów rosnąco. */  
  WHILE (current <= lv_table.LAST) LOOP
    dbms_output.put_line(
      'Indeks ['||current||'] Wartość ['||lv_table(current)||']');
    /* Przechodzenie do następnego indeksu. */
    current := lv_table.NEXT(current);
  END LOOP;
END;
/

/* ================================================================
||  Metoda FIRST
|| ================================================================*/

DECLARE
  /* Definicja tablicy asocjacyjnej. */
  TYPE x_table IS TABLE OF INTEGER
    INDEX BY VARCHAR2(9 CHAR);

  /* Deklaracja zmiennej na tablicę asocjacyjną. */
  lv_list  X_TABLE;
BEGIN
  /* Dodawanie elementów do tablicy asocjacyjnej. */
  lv_table('Siedem') := 7;
  lv_table('Osiem') := 8;

  /* Wyświetlanie elementu zwróconego przez pierwszy indeks w postaci łańcucha znaków. */
  dbms_output.put_line(
    'Indeks ['||lv_table.FIRST||']['||lv_list(lv_list.FIRST)||']');
END;
/

/* ================================================================
||  Metoda LAST
|| ================================================================*/

DECLARE
  /* Definicja tablicy VARRAY. */
  TYPE x_varray IS VARRAY(5) OF INTEGER;
  
  /* Deklaracja zainicjowanej kolekcji. */  
  lv_array  X_VARRAY := x_varray(1,2,3);
BEGIN
  /* Wyświetlanie wartości funkcji COUNT i LIMIT. */
  dbms_output.put_line(
    'Count['||lv_array.COUNT||']: Limit['||lv_array.LIMIT||']');
END;
/

/* ================================================================
||  Metoda NEXT
|| ================================================================*/

DECLARE
  /* Deklaracja zmiennej o znaczącej nazwie. */ 
  current INTEGER;
  
  /* Definicja tabeli zagnieżdżonej. */
  TYPE x_table IS TABLE OF VARCHAR2(6);
  
  /* Deklaracja zainicjowanej kolekcji. */
  lv_table  X_TABLE := x_table('Jeden','Dwa','Trzy','Cztery','Pięć');
BEGIN
  /* Ustawianie początkowego indeksu. */  
  current := lv_table.FIRST;

  /* Wczytywanie indeksu rosnąco. */  
  WHILE (current <= lv_table.LAST) LOOP
    dbms_output.put_line(
      'Indeks ['||current||'] Wartość ['||lv_table(current)||']');
    /* Przechodzenie do następnego indeksu. */
    current := lv_table.NEXT(current);
  END LOOP;
END;
/

/* ================================================================
||  Metoda PRIOR
|| ================================================================*/

DECLARE
  /* Deklaracja zmiennej o znaczącej nazwie. */ 
  current INTEGER;
  
  /* Definicja tabeli zagnieżdżonej. */
  TYPE x_table IS TABLE OF VARCHAR2(6);
  
  /* Deklaracja zainicjowanej kolekcji. */
  lv_table  X_TABLE := x_table('Jeden','Dwa','Trzy','Cztery','Pięć');
BEGIN
  /* Ustawianie indeksu początkowego. */  
  current := lv_table.LAST;

  /* Wczytywanie indeksu rosnąco. */  
  WHILE (current >= lv_table.FIRST) LOOP
    dbms_output.put_line(
      'Indeks ['||current||'] Wartość ['||lv_table(current)||']');
    /* Przechodzenie do następnego indeksu. */
    current := lv_table.PRIOR(current);
  END LOOP;
END;
/

/* ================================================================
||  Metoda TRIM
|| ================================================================*/

DECLARE
  /* Deklaracja zmiennej o znaczącej nazwie. */
  current INTEGER;

  /* Definicja tabeli zagnieżdżonej. */
  TYPE x_table IS TABLE OF VARCHAR2(6);

  /* Deklaracja zainicjowanej kolekcji. */
  lv_table  X_TABLE := x_table('Jeden','Dwa','Trzy','Cztery','Pięć');
BEGIN
  /* Usuwanie elementu o indeksie 3. */
  lv_table.TRIM(3);

  /* Ustawianie początkowego indeksu. */
  current := lv_table.FIRST;

  /* Wczytywanie indeksu rosnąco. */
  WHILE (current <= lv_table.LAST) LOOP
    dbms_output.put_line(
      'Indeks ['||current||'] Wartość ['||lv_table(current)||']');

      /* Przechodzenie do następnego indeksu. */
    current := lv_table.NEXT(current);
  END LOOP;
END;
/
