// --------------------------------------------------------------------
// DataTablePane.java
// Dodatek D, Oracle Database 11g. Programowanie w jzyku PL/SQL
// Michael McLaughlin
//
// Ten kod ilustruje konfigurowanie panelu JTabbedPane do wpisywania
// komponentw zapytania.
// --------------------------------------------------------------------

// Definicja struktury pakietu.
package plsql.jdbc;

// Importowanie klas.
import java.awt.Dimension;
import java.awt.Font;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;

// -----------------------------------------------------------------/
public class DataTablePane extends JTabbedPane {

  // Ustawianie staych.
  public static int TABLE_COLUMN_ALL = 1;
  public static int TABLE_AND_COLUMN = 2;
  public static int TABLE_COLUMN_KEY = 5;

  // Inicjowanie komponentw.
  private JTextArea queryTableName = new JTextArea();
  private JTextArea queryColumnName = new JTextArea();
  private JTextArea queryKeyColumnName = new JTextArea();
  private JTextArea queryKeyColumnValue = new JTextArea();
  private JTextArea operatingSystem = new JTextArea("WINDOWS");
  // -----------------------------------------------------------------/
  public DataTablePane() {
    setFont();
    setMessage(4);
    setTabLayoutPolicy(JTabbedPane.SCROLL_TAB_LAYOUT); }
  // -----------------------------------------------------------------/
  public DataTablePane(int tabs) {
    setFont();
    //if (tabs
    setMessage(tabs);
    setTabLayoutPolicy(JTabbedPane.SCROLL_TAB_LAYOUT); }
  // -----------------------------------------------------------------/
  public String getTableName() {
    return queryTableName.getText(); }
  // -----------------------------------------------------------------/
  public String getColumnName() {
    return queryColumnName.getText(); }
  // -----------------------------------------------------------------/
  public String getKeyColumnName() {
    return queryKeyColumnName.getText(); }
  // -----------------------------------------------------------------/
  public String getKeyColumnValue() {
    return queryKeyColumnValue.getText(); }
  // -----------------------------------------------------------------/
  public String getOperatingSystem() {
    return operatingSystem.getText(); }
  // -----------------------------------------------------------------/
  public void getTable() {
    System.out.println("Informacje o zapytaniu:");
    System.out.println("=============================================");
    if (!getTableName().isEmpty())
      System.out.println("Tabela\t["+getTableName().toUpperCase()+"]");
    if (!getColumnName().isEmpty())
      System.out.println("Sprawdzana kolumna\t["+getColumnName().toUpperCase()+"]");
    if (!getKeyColumnName().isEmpty())
      System.out.println("Kolumna klucza\t["+getKeyColumnName().toUpperCase()+"]");
    if (!getKeyColumnValue().isEmpty())
      System.out.println("Warto klucza\t["+getKeyColumnValue().toUpperCase()+"]");
    if (!getOperatingSystem().isEmpty())
      System.out.println("System operacyjny\t["+getOperatingSystem().toUpperCase()+"]");
    System.out.println("============================================="); }
  // -----------------------------------------------------------------/
  private void setFont() {
    queryTableName.setFont(new Font(Font.SANS_SERIF,Font.PLAIN,14));
    queryColumnName.setFont(new Font(Font.SANS_SERIF,Font.PLAIN,14));
    queryKeyColumnName.setFont(new Font(Font.SANS_SERIF,Font.PLAIN,14));
    queryKeyColumnValue.setFont(new Font(Font.SANS_SERIF,Font.PLAIN,14));
    operatingSystem.setFont(new Font(Font.SANS_SERIF,Font.PLAIN,14)); }
  // -----------------------------------------------------------------/
  private void setMessage(int tabs) {
    setFont();

    if (tabs > 2 && tabs < 4) tabs--;

    // Porzdkowanie zakadek.
    for (int i = 0;i < tabs;i++)
      switch (i) {
        case 0:
          add("Tabela",queryTableName);
          break;
        case 1:
          add("Kolumna",queryColumnName);
          break;
        case 2:
          add("Naz. kl.",queryKeyColumnName);
          break;
        case 3:
          add("War. kl.",queryKeyColumnValue);
          break; }

    // Domylnie na kocu ustawiana jest nazwa systemu.
    add("System",operatingSystem);

    // Okrelenie rozmiaru panelu.
    setPreferredSize(new Dimension(350,50)); }}
