// --------------------------------------------------------------------
// FileIO.java
// Dodatek D, Oracle Database 11g. Programowanie w jzyku PL/SQL
// Michael McLaughlin
//
// Ten kod ilustruje wczytywanie plikw.
// --------------------------------------------------------------------

// Definicja struktury pakietu.
package plsql.fileio;

// Importowanie klas.
import java.awt.Component;
import java.awt.image.BufferedImage;
import java.io.BufferedReader;
import java.io.EOFException;
import java.io.IOException;
import java.io.File;
import java.io.FileReader;
import javax.imageio.ImageIO;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;

// Pomocnicze pliki pakietu.
import plsql.fileio.FileTypeFilter;
import plsql.fileio.InvalidFileException;

// ---------------------------------------------------------------------------/
public abstract class FileIO {

  // Definicja staych typw prostych.
  private final static int ERROR       = JOptionPane.ERROR_MESSAGE;
  private final static int INFORMATION = JOptionPane.INFORMATION_MESSAGE;
  private final static int PLAIN       = JOptionPane.PLAIN_MESSAGE;
  private final static int QUESTION    = JOptionPane.QUESTION_MESSAGE;

  // Definicja zmiennej typu prostego.
  private static boolean componentEnabled = false;

  // Definicja klasy nakadki.
  private static String contents = new String();

  // Definicje zmiennych na potrzeby Swinga.
  private static Component caller;
  private static JFileChooser fileChooser;
  private static javax.swing.filechooser.FileFilter[] filter;

  // Definicje zmiennych IO.
  private static BufferedReader input;
  private static File file;
  private static FileReader inFile;
  // -------------------------------------------------------------------------/
  public static File findFile(Component frame) {

    // Konfiguracja rodowiska.
    setComponent(frame);
    setFileChooser();
    setCurrentDirectory();

    // Wywoanie wyboru plikw i zwrcenie kodu.
    int result = fileChooser.showOpenDialog(frame);

    // Sprawdzanie, czy wybrano przycisk Cancel (Anuluj).
    if (result == JFileChooser.CANCEL_OPTION)  { return null; }

    // Inicjowanie zmiennej za pomoc zwrconego pliku.
    file = fileChooser.getSelectedFile();

    // Zwrcenie pliku.
    return file; }
  // -------------------------------------------------------------------------/
  public static File nameFile(Component frame) {

    // Konfiguracja rodowiska.
    setComponent(frame);
    setFileChooser();
    setCurrentDirectory();

    // Wywoanie wyboru plikw i zwrcenie kodu.
    int result = fileChooser.showSaveDialog(frame);

    // Sprawdzanie, czy wybrano przycisk Cancel (Anuluj).
    if (result == JFileChooser.CANCEL_OPTION)  { return null; }

    // Inicjowanie zmiennej za pomoc zwrconego pliku.
    file = fileChooser.getSelectedFile();

    // Zwrcenie pliku.
    return file; }
  // -------------------------------------------------------------------------/
  public static String openFile(File file) {
    return openFile(null,file); }
  // -------------------------------------------------------------------------/
  public static String openFile(Component frame,File file)
  {
    // Inicjowanie komponentu.
    setComponent(frame);

    // Definicja i inicjowanie lokalnych zmiennych Swinga.
    String retValue = new String("");

    // Zgoszenie bdu, jeli nazwa pliku to null lub plik jest otwarty.
    if (file == null || file.getName().equals("")) {

      // Jeli komponent nie jest gotowy.
      if (!componentEnabled) {
        // Zgaszanie wyjtku czasu wykonania, jeli referencja ma warto null.
        throw new InvalidFileException("Referencja do pliku ma warto null."); }}
    else {

      // Otwarcie pliku do sekwencyjnego odczytu.
      try {

        // Tworzenie obiektu BufferedReader na potrzeby wczytywania danych wiersz po wierszu.
        input = new BufferedReader(new FileReader(file));

        // Wczytywanie pliku wiersz po wierszu do momentu dojcia do znacznika koca pliku.
        readFile();

        // Przypisanie wczytanych danych.
        retValue = contents;

        // Zamknicie pliku, poniewa wymaga tego statyczny kontekst.
        input.close(); }
      catch (IOException e) {

        // Jeli komponent jest gotowy.
        if (componentEnabled) {

          // Wywietlenie okna dialogowego.
          showMessageDialog("Nie znaleziono nazwy pliku lub cieki.",
                            "Bd wejcia-wyjcia",ERROR); }
        else {
          // Zgoszenie wyjtku czasu wykonania przy bednej nazwie pliku lub ciece.
          throw new InvalidFileException("Nie znaleziono nazwy pliku lub cieki."); }}}

    // Zwrcenie wartoci.
    return retValue; }
  // -----------------------------------------------------------------/
  private static String readEntry() {
    try {

      // Definicje zmiennych metody.
      int c;
      StringBuffer buffer = new StringBuffer();

      // Wczytanie pierwszego znaku.
      c = System.in.read();

      // Wczytanie pozostaych znakw.
      while (c != '\n' && c != -1) {
        buffer.append((char) c);
        c = System.in.read(); }

      // Zwrcenie zawartoci bufora.
      return buffer.toString().trim(); }
    catch (IOException e) {
      return null; }}
  // -------------------------------------------------------------------------/
  private static void readFile() {

    // Definicja acucha znakw.
    String line = new String();

    // Prba wczytania pliku.
    try
    {
      // Wczytanie pierwszego wiersza do zmiennej typu String.
      line = input.readLine();

      // Doczenie wiersza do acucha z zawartoci pliku.
      contents = line + "\n";

      // Wczytywanie pliku do ostatniego wiersza.
      while (line != null) {
        line = input.readLine();

        // Doczenie wiersza do zawartoci pliku.
        if (line != null)
          { contents += line + "\n"; }}}
    catch ( EOFException eofe) {

      // Wywietlenie okna dialogowego.
      showMessageDialog("Brak dalszych wierszy.",
                        "Bd koca pliku",ERROR); }
    catch ( IOException ioe) {

      // Wywietlenie okna dialogowego.
      showMessageDialog("Bd odczytu pliku.",
                        "Bd wejcia-wyjcia",ERROR); }}
  // -------------------------------------------------------------------------/
  private static void setComponent(Component frame) {

    // Jeli Component ma warto rn od null, inicjowanie go.
    if (frame != null)
    {
      // Inicjowanie przez wywoanie obiektu Component.
      caller = frame;

      // Zmiana opcji okrelajcej, czy komponent jest gotowy.
      componentEnabled = true; }}
  // -------------------------------------------------------------------------/
  private static void setCurrentDirectory() {

    // Sprawdzanie systemu operacyjnego: MS Windows lub UNIX.
    if (new Character(File.separatorChar).charValue() == '\\') {
      file = new File("C:\\"); }
    else {
      file = new File("/"); }

    // Inicjowanie stanu obiektu JFileChooser.
    fileChooser.setCurrentDirectory(file); }
  // -------------------------------------------------------------------------/
  private static void setFileChooser() {

    // Inicjowanie obiektu FileChooser
    fileChooser = new JFileChooser();

    // Inicjowanie obiektu FileFilter.
    javax.swing.filechooser.FileFilter[] filter =
      new javax.swing.filechooser.FileFilter[]
      { new FileTypeFilter("C/C++",
          new String[] { "c","cpp","h","hpp","cxx","hxx","inl" }),
        new FileTypeFilter("HTML",
          new String[] { "htm","html","stm" }),
        new FileTypeFilter("Image",
          new String[] { "gif","jpg","png" }),
        new FileTypeFilter("Java",
          new String[] { "java","sqlj" }),
        new FileTypeFilter("Log",
          new String[] { "log","lst" }),
        new FileTypeFilter("Oracle",
          new String[] { "pls","pll","ora","sql" }),
        new FileTypeFilter("Text",
          new String[] { "cfg","ini","txt" })
      };

    // Zapenianie w ptli obiektu JFileChooser za pomoc filtra FileFilter.
    for (int i = 0;i < filter.length;i++)
    {
      // Przypisanie filtra FileFilter do obiektu JFileChooser.
      fileChooser.addChoosableFileFilter(filter[i]); }

    // Ustawienie filtra obiektu JFileChooser za pomoc wszystkich wartoci obiektu FileFilter.
    fileChooser.setFileFilter(fileChooser.getAcceptAllFileFilter()); }
  // -------------------------------------------------------------------------/
  private static void showMessageDialog(String msg,String title,int msgType) {

    // Wywietlenie okna dialogowego.
    JOptionPane.showMessageDialog(caller,msg,title,msgType);

    // Sygnalizowanie bdu w celu zwolnienia zasobw w systemie Windows.
    System.exit(0); }}
  // -------------------------------------------------------------------------/
