// --------------------------------------------------------------------
// DataConnectionPane.java
// Dodatek D, Oracle Database 11g. Programowanie w jzyku PL/SQL
// Michael McLaughlin
//
// Ten kod ilustruje konfigurowanie panelu JTabbedPane do wpisywania
// i wczytywania komponentw poczenia z baz danych.
// --------------------------------------------------------------------

// Definicja struktury pakietu.
package plsql.jdbc;

// Importowanie klas.
import java.awt.Dimension;
import java.awt.Font;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;

// -----------------------------------------------------------------/
public class DataConnectionPane extends JTabbedPane {

  // Inicjowanie komponentw.
  private JTextArea hostTA = new JTextArea();
  private JTextArea portTA = new JTextArea();
  private JTextArea dbnameTA = new JTextArea();
  private JTextArea useridTA = new JTextArea();
  private JTextArea passwdTA = new JTextArea();
  // -----------------------------------------------------------------/
  public DataConnectionPane() {
    setFont();
    setMessage();
    setTabLayoutPolicy(JTabbedPane.SCROLL_TAB_LAYOUT); }
  // -----------------------------------------------------------------/
  public String getHost() {
    return hostTA.getText(); }
  // -----------------------------------------------------------------/
  public String getPort() {
    return portTA.getText(); }
  // -----------------------------------------------------------------/
  public String getDatabase() {
    return dbnameTA.getText(); }
  // -----------------------------------------------------------------/
  public String getUserID() {
    return useridTA.getText(); }
  // -----------------------------------------------------------------/
  public String getPassword() {
    return passwdTA.getText(); }
  // -----------------------------------------------------------------/
  public void getConnection() {
    System.out.println("Informacje o poczeniu:");
    System.out.println("=============================================");
    System.out.println("serwer\t["+hostTA.getText()+"]");
    System.out.println("port\t["+portTA.getText()+"]");
    System.out.println("baza\t["+dbnameTA.getText()+"]");
    System.out.println("uytkownik\t["+useridTA.getText()+"]");
    System.out.println("haso\t["+passwdTA.getText()+"]");
    System.out.println("============================================="); }
  // -----------------------------------------------------------------/
  private void setFont() {
    hostTA.setFont(new Font(Font.SANS_SERIF,Font.PLAIN,14));
    portTA.setFont(new Font(Font.SANS_SERIF,Font.PLAIN,14));
    dbnameTA.setFont(new Font(Font.SANS_SERIF,Font.PLAIN,14));
    useridTA.setFont(new Font(Font.SANS_SERIF,Font.PLAIN,14));
    passwdTA.setFont(new Font(Font.SANS_SERIF,Font.PLAIN,14)); }
  // -----------------------------------------------------------------/
  private void setMessage() {
    setFont();
    add("Serwer",hostTA);
    add("Port",portTA);
    add("Baza danych",dbnameTA);
    add("Uytkownik",useridTA);
    add("Haso",passwdTA);
    setPreferredSize(new Dimension(350,50)); }}
