/*
 * HelloWorldSQL.sql
 * Rozdzia 15., Oracle Database 11g. Programowanie w jzyku PL/SQL
 * Michael McLaughlin
 *
 * UWAGI:
 *
 * Ten skrypt tworzy nakadk jzyka PL/SQL na plik klasy jzyka Java.
 */

-- Uywane do diagnozowania skryptu.
SET ECHO ON
SET FEEDBACK ON
SET PAGESIZE 49999
SET SERVEROUTPUT ON SIZE 1000000

CREATE OR REPLACE AND RESOLVE JAVA SOURCE NAMED HelloWorldSQL AS
// Definicja klasy.
public class HelloWorldSQL {

public static String hello() {
  return "Hello World."; }
  
public static String hello(String name) {
  return "Hello " + name + "."; }
}
/

-- Specyfikacja pakietu bdcego nakadk jzyka PL/SQL na plik klasy jzyka Java.
CREATE OR REPLACE PACKAGE hello_world_sql AS
  FUNCTION hello
  RETURN VARCHAR2;

  FUNCTION hello
  ( who  VARCHAR2 )
  RETURN VARCHAR2;
END hello_world_sql;
/

-- Ciao pakietu bdcego nakadk jzyka PL/SQL na plik klasy jzyka Java.
CREATE OR REPLACE PACKAGE BODY hello_world_sql AS

  FUNCTION hello
  RETURN VARCHAR2 IS
  LANGUAGE JAVA
  NAME 'HelloWorldSQL.hello() return String';

  FUNCTION hello
  ( who  VARCHAR2 )
  RETURN VARCHAR2 IS
  LANGUAGE JAVA
  NAME 'HelloWorldSQL.hello(java.lang.String) return String';
END hello_world_sql;
/

-- Tworzy funkcj-nakadk jzyka PL/SQL na metod klasy jzyka Java.
CREATE OR REPLACE FUNCTION hello
( who VARCHAR2) RETURN VARCHAR2 IS
LANGUAGE JAVA
NAME 'HelloWorldSQL.hello(java.lang.String) return String';
/

COL salutation FORMAT A14

-- Zapytanie do obiektu.
SELECT   hello('Nathan') AS salutation
FROM     dual;