/*
 * HelloWorld3.sql
 * Rozdzia 15., Oracle Database 11g. Programowanie w jzyku PL/SQL
 * Michael McLaughlin
 *
 * UWAGI:
 *
 * Ten skrypt tworzy nakadk jzyka PL/SQL na plik klasy jzyka Java.
 */

-- Uywane do diagnozowania skryptu.
SET ECHO ON
SET FEEDBACK ON
SET PAGESIZE 49999
SET SERVEROUTPUT ON SIZE 1000000

-- Tworzy tabel zagniedon przechowujc liczby.
CREATE OR REPLACE TYPE varchar2_type AS TABLE OF NUMBER;
/

-- Usuwa obiekty, aby mona wielokrotnie uruchomi skrypt.
BEGIN

  FOR i IN (SELECT   table_name
            FROM     user_tables
            WHERE    table_name = 'MYTABLE' ) LOOP

    -- Uywa instrukcji NDS do usunicia zalenego typu obiektowego.
    EXECUTE IMMEDIATE 'DROP TABLE mytable';
    
  END LOOP;
  
END;
/

-- Tworzy tabel potrzebn w skrypcie.
CREATE TABLE mytable
( character VARCHAR2(100));

-- Tworzy pakiet jzyka PL/SQL bdcy nakadk na plik klasy jzyka Java.
CREATE OR REPLACE PACKAGE hello_world3 AS

  -- Definicja procedury jednoargumentowej.
  PROCEDURE doDML
  ( dml   VARCHAR2
  , input VARCHAR2 );
  
  -- Definicja funkcji jednoargumentowej.
  FUNCTION doDQL
  ( dql   VARCHAR2 )
  RETURN  VARCHAR2;
  
END hello_world3;
/

-- Tworzy pakiet jzyka PL/SQL bdcy nakadk na plik klasy jzyka Java.
CREATE OR REPLACE PACKAGE BODY hello_world3 AS

  -- Definicja procedury jednoargumentowej.
  PROCEDURE doDML
  ( dml   VARCHAR2
  , input VARCHAR2 ) IS
  LANGUAGE JAVA
  NAME 'HelloWorld3.doDML(java.lang.String,java.lang.String)';
  
  -- Definicja funkcji jednoargumentowej.
  FUNCTION doDQL
  ( dql   VARCHAR2 )
  RETURN  VARCHAR2 IS
  LANGUAGE JAVA
  NAME 'HelloWorld3.doDQL(java.lang.String) return String';
  
END hello_world3;
/

COL object_name   FORMAT A30
COL object_type   FORMAT A12
COL object_status FORMAT A7

-- Pobieranie obiektw.
SELECT   object_name
,        object_type
,        status
FROM     user_objects
WHERE    object_name IN ('HelloWorld3','HELLO_WORLD3');


BEGIN

  hello_world3.doDML('INSERT INTO MYTABLE VALUES (?)','Bobby McGee');
  
  DBMS_OUTPUT.PUT_LINE(hello_world3.doDQL('SELECT character FROM mytable'));

END;
/

-- Testowanie klasy jzyka Java przy uyciu nakadki jzyka PL/SQL.
SELECT   hello_world3.doDQL('SELECT character FROM mytable')
FROM     dual;