/*
 * write_pipe.sql
 * Rozdzia 12., Oracle Database 11g. Programowanie w jzyku PL/SQL
 * Michael McLaughlin
 *
 * UWAGI:
 *
 * This script write three messages to a private or public
 * pipe by using the DBMS_PIPE package.
 *
 * - This script is dependent on create_pipe2.sql and it is
 *   called before running the anonymous PL/SQL block.
 */

-- Uywane do diagnozowania skryptu.
SET ECHO ON
SET FEEDBACK ON
SET PAGESIZE 49999
SET SERVEROUTPUT ON SIZE 1000000

-- Gwarantowanie utworzenia potoku publicznego
@create_pipe2.sql

-- Demonstruje wysyanie komunikatw
DECLARE

  -- Definicja przeamania wiersza sucego do rozdzielania zapisw danych w potoku
  line_return VARCHAR2(1) := CHR(10);

  -- Definicja zmiennej na zwracan warto
  flag        INTEGER;

BEGIN

  -- Usuwanie zawartoci potoku
  dbms_pipe.purge('PLSQL$MESSAGE_INBOX');

  -- Wywietlanie nagwka danych wejciowych
  DBMS_OUTPUT.PUT_LINE('Komunikaty wejsciowe potoku');
  DBMS_OUTPUT.PUT_LINE('---------------------------');

  -- Ptla for bazujca na przedziale wysya trzy komunikaty 
  FOR i IN 1..3 LOOP

    -- Wywietla wiersz danych wejciowych
    DBMS_OUTPUT.PUT_LINE('Komunikat ['||i||']');

    -- Odpowiednia procedura umieszcza komunikat w buforze lokalnym 
    DBMS_PIPE.PACK_MESSAGE('Komunikat ['||i||']'||line_return);

    -- Wysyanie komunikatu; zwrcenie wartoci zero oznacza powodzenie
    flag := DBMS_PIPE.SEND_MESSAGE('PLSQL$MESSAGE_INBOX');

  END LOOP;

  -- Wywietlenie komunikatu na podstawie wartoci zmiennej flag
  IF (flag = 0) THEN
    DBMS_OUTPUT.PUT_LINE('Przeslano komunikat do PLSQL$MESSAGE_INBOX.');
  END IF;

END;
/
