/*
 * register_interest.sql
 * Rozdzia 12., Oracle Database 11g. Programowanie w jzyku PL/SQL
 * Michael McLaughlin
 *
 * UWAGI:
 *
 * Ten skrypt rejestruje w pakiecie DBMS_ALERT
 * zainteresowanie tabel MESSAGES
 */

-- Uywane do diagnozowania skryptu.
SET ECHO ON
SET FEEDBACK ON
SET PAGESIZE 49999
SET SERVEROUTPUT ON SIZE 1000000

-- Usuwa zainteresowanie w pakiecie DBMS_ALERT
BEGIN

  -- Remove/deregister interest from an alert.
  DBMS_ALERT.REMOVE('EVENT_MESSAGE_QUEUE');

END;
/

-- Wywoanie wyzwalacza, co powoduje take utworzenie potrzebnej tabeli
@create_signal_trigger.sql

-- Rejestrowanie zainteresowania alertem
BEGIN

  -- Rejestrowanie zainteresowania alertem
  DBMS_ALERT.REGISTER('EVENT_MESSAGE_QUEUE');

END;
/
