/*
 * read_local_error.sql
 * Rozdzia 12., Oracle Database 11g. Programowanie w jzyku PL/SQL
 * Michael McLaughlin
 *
 * UWAGI:
 *
 * Ten skrypt uywa pakietu DBMS_PIPE do zapisu lokalnego komunikatu
 * do niejawnego anonimowego potoku sesji. Ten potok ma nastpujce
 * cechy:
 *
 * - Dostp do niego maj uytkownicy z uprawnieniami EXECUTE do
 *   pakietu DBMS_PIPE
 * - Jego odczyt odbywa si automatycznie w wyniku wywoania
 *   procedury DBMS_PIPE.UNPACK_MESSAGE w sesji
 * - Jest anonimowy pod tym wzgldem, e nie mona
 *   sprawdzi jego nazwy, ani adresu na podstawie nazwy
 * - Do usuwania zawartoci anonimowych potokw lokalnych suy
 *   procedura DBMS_PIPE.RESET_BUFFER
 * - Ten skrypt trzeba uruchomi z tego samego
 *   katalogu, co write_local.sql i read_local.sql
 */

-- Uywane do diagnozowania skryptu.
SET ECHO ON
SET FEEDBACK ON
SET PAGESIZE 49999
SET SERVEROUTPUT ON SIZE 1000000

-- Gwarantuje dostpno danych w buforze lokalnym
@write_local.sql

-- Uruchomienie wywoania DBMS_PIPE.RECEIVE_MESSAGE w celu oprnienia bufora lokalnego
SELECT   DBMS_PIPE.RECEIVE_MESSAGE('Nowhere',0)
FROM     dual;

@read_local.sql
