/*
 * create_nds6.sql
 * Rozdzia 11., Oracle Database 11g. Programowanie w jzyku PL/SQL
 * Michael McLaughlin
 *
 * UWAGI:
 *
 * Ten skrypt NDS uywa miejsc na dane i zmiennych powizanych
 * do wczytywania i zapisywania wartoci w instrukcji NDS.
 */

-- Uywane do diagnozowania skryptu.
SET ECHO ON
SET FEEDBACK ON
SET PAGESIZE 49999
SET SERVEROUTPUT ON SIZE 1000000

DECLARE
  -- Jawna definicja struktury rekordowej.
  target  CLOB;
  source  VARCHAR2(2000) := 'Klasyk w reyserii Mela Brooksa!';
  movie   VARCHAR2(60) := 'Young Frankenstein';
  stmt    VARCHAR2(2000);
BEGIN
  -- Przygotowanie instrukcji.
  stmt := 'BEGIN '
       || 'UPDATE  item '
       || 'SET     item_desc = empty_clob() '
       || 'WHERE   item_id = '
       || '          (SELECT item_id '
       || '           FROM   item '
       || '           WHERE  item_title = :input) '
       || 'RETURNING item_desc INTO :descriptor;'
       || 'END;';

  EXECUTE IMMEDIATE stmt USING movie, IN OUT target;
  dbms_lob.writeappend(target,LENGTH(source),source);
  COMMIT;
END;
/

SELECT item_desc FROM item WHERE item_title = 'Young Frankenstein';

