/*
 * create_nds4.sql
 * Rozdzia 11., Oracle Database 11g. Programowanie w jzyku PL/SQL
 * Michael McLaughlin
 *
 * UWAGI:
 *
 * Ten skrypt NDS uywa miejsc na dane i zmiennych powizanych do
 * zwrcenia wartoci z zapytania.
 */

-- Uywane do diagnozowania skryptu.
SET ECHO ON
SET FEEDBACK ON
SET PAGESIZE 49999
SET SERVEROUTPUT ON SIZE 1000000

DECLARE
  -- Jawna definicja struktury rekordowej.
  TYPE title_record IS RECORD
  ( item_title     VARCHAR2(60)
  , item_subtitle  VARCHAR2(60));
  -- Definicje zmiennych na potrzeby instrukcji dynamicznej.
  title_cursor  SYS_REFCURSOR;
  title_row     TITLE_RECORD;
  stmt          VARCHAR2(2000);
BEGIN
  -- Przygotowanie instrukcji.
  stmt := 'SELECT  item_title, item_subtitle '
       || 'FROM    item '
       || 'WHERE   SUBSTR(item_title,1,12) = :input';
  
  -- Otwarcie i wczytanie kursora dynamicznego oraz zamknicie go.
  OPEN title_cursor FOR stmt USING 'Harry Potter';
  LOOP
    FETCH title_cursor INTO title_row;
    EXIT WHEN title_cursor%NOTFOUND;
    dbms_output.put_line(
      '['||title_row.item_title||']['||title_row.item_subtitle||']');
  END LOOP;
  CLOSE title_cursor;
END;
/

