/*
 * create_dbms_sql4.sql
 * Rozdzia 11., Oracle Database 11g. Programowanie w jzyku PL/SQL
 * Michael McLaughlin
 *
 * UWAGI:
 *
 * Ten skrypt uywa pakietu DBMS_SQL do pobrania zwrconego wiersza.
 */

-- Uywane do diagnozowania skryptu.
SET ECHO ON
SET FEEDBACK ON
SET PAGESIZE 49999
SET SERVEROUTPUT ON SIZE 1000000

DECLARE
  c                         INTEGER := dbms_sql.open_cursor;
  fdbk                      INTEGER;
  statement                 VARCHAR2(2000);
  item_id                   NUMBER := 1081;
  item_title                VARCHAR2(60);
  item_subtitle             VARCHAR2(60);

BEGIN

  -- Tworzenie i przetwarzanie instrukcji SQL.
  statement := 'SELECT item_title, item_subtitle '
            || 'FROM item WHERE item_id = :item_id';
  dbms_sql.parse(c,statement,dbms_sql.native);

  -- Odwzorowywanie kolumn, wykonywanie instrukcji i kopiowanie wynikw.
  dbms_sql.define_column(c,1,item_title,60);    -- Definicja zmiennej w trybie OUT.
  dbms_sql.define_column(c,2,item_subtitle,60); -- Definicja zmiennej w trybie OUT.
  dbms_sql.bind_variable(c,'item_id',item_id);  -- Zmienna powizana o trybie IN.
  fdbk := dbms_sql.execute_and_fetch(c);
  dbms_sql.column_value(c,1,item_title);        -- Kopiowanie kolumny z zapytania do zmiennej.
  dbms_sql.column_value(c,2,item_subtitle);     -- Kopiowanie kolumny z zapytania do zmiennej.

  -- Wywietlanie zwracanej wartoci i zamykanie kursora.  
  dbms_output.put_line('['||item_title||']['||NVL(item_subtitle,'None')||']');
  dbms_sql.close_cursor(c);

END;
/