/*
 * create_insteadof_trigger.sql
 * Rozdzia 10., Oracle Database 11g. Programowanie w jzyku PL/SQL
 * Michael McLaughlin
 *
 * UWAGI:
 *
 * Ten skrypt tworzy wyzwalacz zastpujcy.
 */

SET ECHO OFF
SET FEEDBACK ON
SET NULL '<Null>'
SET PAGESIZE 999
SET SERVEROUTPUT ON

CREATE OR REPLACE TRIGGER account_list_dml
  INSTEAD OF INSERT OR UPDATE OR DELETE ON account_list
  FOR EACH ROW
DECLARE
  -- Zmienna rdowa.
  source account_list.full_name%TYPE := :new.full_name;
  -- Przetwarzane zmienne.
  fname  VARCHAR2(43);
  mname  VARCHAR2(1);
  lname  VARCHAR2(43);
  -- Sprawdzanie, czy zalenoci zostay usunite.
  FUNCTION get_dependents (member_id NUMBER) RETURN BOOLEAN IS
    rows NUMBER := 0;
    CURSOR c (member_id_in NUMBER) IS
      SELECT COUNT(*) FROM contact WHERE member_id = member_id_in;
  BEGIN
    OPEN c (member_id);
    FETCH c INTO rows;
    IF rows > 0 THEN
      RETURN FALSE;
    ELSE
      RETURN TRUE;
    END IF;
  END get_dependents;
BEGIN
  
  IF INSERTING THEN -- Przy zdarzeniu INSERT.
  
    RAISE_APPLICATION_ERROR(-20000,'Brak danych do wykonania wstawiania!');
  
  ELSIF UPDATING THEN -- Przy zdarzeniu UPDATE.

    -- Przypisanie wartoci do zmiennej rdowej.
    source := :new.full_name;

    -- Przetwarzanie penego nazwiska.
    fname := LTRIM(REGEXP_SUBSTR(source,'(^|^ +)([[:alpha:]]+)',1));
    mname := REGEXP_SUBSTR(
               REGEXP_SUBSTR(
                 source,'( +)([[:alpha:]]+)(( +|. +))',1),'([[:alpha:]])',1);
    lname := REGEXP_SUBSTR(
               REGEXP_SUBSTR(
                 source,'( +)([[:alpha:]]+)( +$|$)',1),'([[:alpha:]]+)',1);
    
    -- Aktualizacja nazwiska w tabeli podstawowej.
    UPDATE contact
    SET    first_name = fname
    ,      middle_initial = mname
    ,      last_name = lname
    WHERE  contact_id = :old.contact_id;
    
  ELSIF DELETING THEN -- Przy zdarzeniu DELETE.
  
    DELETE FROM contact WHERE member_id = :old.member_id;
    
    -- Jeli nie ma elementw podrzdnych, usuwa element nadrzdny.
    IF get_dependents(:old.member_id) THEN
      DELETE FROM member WHERE member_id = :old.member_id;
    END IF;
    
  END IF;
  
END;
/
