/*
 * create_components.sql
 * Rozdzia 9., Oracle Database 11g. Programowanie w jzyku PL/SQL
 * Michael McLaughlin
 *
 * UWAGI:
 *
 * Ten skrypt ilustruje zarzdzanie w pakiecie
 * wspuytkowanymi zmiennymi z ciaa pakietu i komponentami
 * z poziomu pakietu.
 */

-- Uywane do diagnozowania skryptu.
SET ECHO ON
SET FEEDBACK ON
SET PAGESIZE 49999
SET SERVEROUTPUT ON SIZE 1000000

-- Specyfikacja pakietu.
CREATE OR REPLACE PACKAGE components IS

  -- Deklaracja komponentw pakietu.
  PROCEDURE set (value IN OUT VARCHAR2);
  FUNCTION get RETURN VARCHAR2;

END components;
/

-- Ciao pakietu.
CREATE OR REPLACE PACKAGE BODY components IS
  -- Deklaracje zmiennych wspuytkowanych z poziomu pakietu.
  key NUMBER := 0;
  variable VARCHAR2(20) := 'Warto pocztkowa';

  -- Definicje funkcji i procedury dostpnych tylko w pakiecie.
  FUNCTION locked RETURN BOOLEAN IS
    key NUMBER := 0;
  BEGIN
    IF components.key = key THEN
      components.key := 1;
      RETURN FALSE;
    ELSE
      RETURN TRUE;
    END IF;
  END locked;

  PROCEDURE unlock IS
    key NUMBER := 1;
  BEGIN
    IF components.key = key THEN
      components.key := 0;              -- Wyzerowanie klucza.
      variable := 'Warto pocztkowa'; -- Przywrcenie wartoci pocztkowej zmiennej wspuytkowanej.
    END IF;
  END unlock;

  -- Definicje funkcji i procedury publicznych.
  FUNCTION get RETURN VARCHAR2 IS
  BEGIN
    RETURN variable;
  END get;

  PROCEDURE set (value VARCHAR2) IS
  BEGIN
    IF NOT locked THEN
      variable := value;
      dbms_output.put_line('Nowa warto do momentu odblokowania to ['||get||'].');
      unlock;
    END IF;
  END set;

END components;
/

-- Kod testowy.
VARIABLE current_content VARCHAR2(20)
CALL components.get() INTO :current_content;
SELECT :current_content FROM dual;
EXECUTE components.set('Nowa warto');
CALL components.get() INTO :current_content;
SELECT :current_content FROM dual;
