/*
 * get_bfilename.sql
 * Rozdzia 8., Oracle Database 11g. Programowanie w jzyku PL/SQL
 * Michael McLaughlin
 *
 * Ten skrypt pobiera nazw pliku.
 */

-- Uywane do diagnozowania skryptu.
SET ECHO ON
SET FEEDBACK ON
SET PAGESIZE 49999
SET SERVEROUTPUT ON SIZE 1000000

CREATE OR REPLACE FUNCTION get_bfilename
( table_name        VARCHAR2
, column_name       VARCHAR2
, primary_key_name  VARCHAR2
, primary_key_value VARCHAR2)
RETURN VARCHAR2 IS

  -- Definicja lokalizatora.
  locator           BFILE;

  -- Definicja aliasu i nazwy pliku.
  dir_alias VARCHAR2(255);
  directory VARCHAR2(255);
  file_name VARCHAR2(255);
  
  -- Definicja zmiennej lokalnej uywanej w instrukcji NDS.
  stmt      VARCHAR2(2000);
  delimiter VARCHAR2(1) := '/';

  -- Definicja lokalnego wyjtku zwizanego z przekroczeniem rozmiaru danych.
  directory_num EXCEPTION;
  PRAGMA EXCEPTION_INIT(directory_num,-22285);  

BEGIN

  -- Opakowanie instrukcji w blok anonimowy w celu utworzenia zmiennej w trybie OUT.
  stmt := 'BEGIN '
       || 'SELECT '||column_name||' '
       || 'INTO :locator '
       || 'FROM '||table_name||' '
       || 'WHERE '||primary_key_name||' = '||''''||primary_key_value||''';'
       || 'END;';

  -- Zwrcenie wartoci skalarnej w wyniku przetworzenia dynamicznego zapytania SQL.
  EXECUTE IMMEDIATE stmt USING OUT locator;

  -- Sprawdzanie dostpnoci lokalizatora.
  IF locator IS NOT NULL THEN     
    dbms_lob.filegetname(locator,dir_alias,file_name);
  END IF;

  -- Zwracanie nazwy pliku.
  RETURN delimiter||LOWER(dir_alias)||delimiter||file_name;

EXCEPTION
  WHEN directory_num THEN
  RETURN NULL;

END get_bfilename;
/
