<?php
  /*  ConvertFileToImage.php
   *  Rozdzia 8., Oracle Database 11g. Programowanie w jzyku PL/SQL
   *  Michael McLaughlin
   *
   *  Ten skrypt pobiera obraz z pliku i przeksztaca go na
   *  rysunek w formacie PNG.
   *
   *  UWAGI:
   *
   *  Nagwek musi znale si w znaczniku PHP, poniewa
   *  nie mona wywietli obrazu przed wywoaniem funkcji header(), ktra
   *  informuje o tym, e rysunek ma format PNG.
   */

  // Sprawdza udane nawizanie poczenia z baz danych.
  if ($c = @oci_new_connect("plsql","plsql","orcl"))
  {
    // Deklaracja zmiennych wejciowych.
    (isset($_GET['id']))    ? $id = (int) $_GET['id'] : $id = 1021;

    // Deklaracja instrukcji SELECT jzyka SQL zwracajcej obiekt typu CLOB.
    $stmt = "SELECT   item_photo
             FROM     item
             WHERE    item_id = :id";

    // Przetwarzanie zapytania przy uyciu poczenia.
    $s = oci_parse($c,$stmt);

    // Wizanie zmiennych z kodu PHP z typami biblioteki OCI.
    oci_bind_by_name($s,':id',$id);

    // Wykonywanie instrukcji jzyka PL/SQL.
    if (oci_execute($s)) {

      // Zwraca deskryptor typu LOB i zwalnia zasoby.
      while (oci_fetch($s))
      {
        for ($i = 1;$i <= oci_num_fields($s);$i++)
          if (is_object(oci_result($s,$i)))
          {
            if ($size = oci_result($s,$i)->size())
            {
              $data = oci_result($s,$i)->read($size);
            }
            else
              $data = "&nbsp;";
          }
          else
          {
            if (oci_field_is_null($s,$i))
              $data = "&nbsp;";
            else
              $data = oci_result($s,$i);
          }
      } // Koniec ptli while(oci_fetch($s)).

      // Zwalnianie zasobw.
      oci_free_statement($s);

      // Najpierw program wywietla nagwek.
      header('Content-type: image/png');
      imagepng(imagecreatefromstring($data));
    }

    // Zamknicie poczenia z baz danych.
    oci_close($c);  }
  else  {

    // Przypisanie bdu OCI i formatowanie cudzysoww oraz apostrofw.
    $errorMessage = oci_error();
    print htmlentities($errorMessage['message'])."<br />";
  }
?>