/*
 * varray_dml1.sql
 * Rozdzia 7., Oracle Database 11g. Programowanie w jzyku PL/SQL
 * Michael McLaughlin
 *
 * UWAGI:
 *
 * Ten skrypt tworzy tablice VARRAY i ilustruje korzystanie z nich.
 */

-- Uywane do diagnozowania skryptu.
SET ECHO ON
SET FEEDBACK ON
SET PAGESIZE 49999
SET SERVEROUTPUT ON SIZE 1000000

INSERT INTO individuals VALUES
( individuals_s1.nextval, 'Jan', 'Piotr', 'Kowalski', 'Pan');

INSERT INTO addresses VALUES
( 1
, individuals_s1.currval
,strings
  ('Biuro senatora Kowalskiego'
  ,'Zachodnia 1'
  ,'Pokj nr 200')
,'Gliwice'
,'SL'
,'85701'
,'Polska');

SELECT   street_address
FROM     addresses;

-- Tworzenie tablicowego typu danych jzyka PL/SQL.
CREATE OR REPLACE TYPE varray_nested_table IS TABLE OF VARCHAR2(30 CHAR);

-- Zastosowanie SQL*Plus do sformatowania danych wyjciowych.
COL column_value FORMAT A30

-- Wywietlenie listy sformatowanych elementw tabeli zoonej.
SELECT   *
FROM     TABLE(SELECT   CAST(street_address AS
                             varray_nested_table) 
               FROM     addresses
               WHERE    address_id = 1);

