/*
 * create_nestedtable1.sql
 * Rozdzia 7., Oracle Database 11g. Programowanie w jzyku PL/SQL
 * Michael McLaughlin
 *
 * UWAGI:
 *
 * Ten skrypt tworzy tablice zagniedone i ilustruje korzystanie z nich.
 */

-- Uywane do diagnozowania skryptu.
SET ECHO ON
SET FEEDBACK ON
SET PAGESIZE 49999
SET SERVEROUTPUT ON SIZE 1000000

DECLARE
  -- Definicja typu tabeli zagniedonej.
  TYPE card_table IS TABLE OF VARCHAR2(5 CHAR);

  -- Deklaracja i inicjowanie tabeli zagniedonej o wartociach null.
  cards CARD_TABLE := card_table(NULL,NULL,NULL);
BEGIN

  -- Wywietlanie zainicjowanych wartoci null.
  dbms_output.put_line('Tabela zagniedona zainicjowana wartociami NULL.');
  dbms_output.put_line('---------------------------------------------------');
  FOR i IN 1..3 LOOP
    dbms_output.put     ('Tabela cards['||i||'] ');
    dbms_output.put_line('['||cards(i)||']');
  END LOOP;

  -- Przypisanie wartoci do indeksowanych elementw tabeli.
  cards(1) := 'As';
  cards(2) := 'Dwjka';
  cards(3) := 'Trjka';

  -- Wywietlenie zainicjowanych wartoci.
  dbms_output.put     (CHR(10)); -- Widoczne przeamanie wiersza
  dbms_output.put_line('Tabela zagniedona zainicjowana asem, dwjk i trjk.');
  dbms_output.put_line('--------------------------------------------------------');
  FOR i IN 1..3 LOOP
    dbms_output.put_line('Tabela cards ['||i||'] '||'['||cards(i)||']');
  END LOOP;
END;
/

