/*
 * result_cache.sql
 * Rozdzia 6., Oracle Database 11g. Programowanie w jzyku PL/SQL
 * Michael McLaughlin
 *
 * UWAGI:
 *
 * Ten skrypt tworzy funkcje get_title i uywa nowej funkcji
 * bazy danych Oracle 11g. Nie mona go uruchomi w starszych 
 * wersjach tej bazy.
 */

-- Uywane do diagnozowania skryptu.
SET ECHO ON
SET FEEDBACK ON
SET PAGESIZE 49999
SET SERVEROUTPUT ON SIZE 1000000

-- Tworzenie kolekcji acuchw znakw.
CREATE OR REPLACE TYPE strings AS TABLE OF VARCHAR2(60);
/

CREATE OR REPLACE FUNCTION get_title
( partial_title VARCHAR2 ) RETURN STRINGS
RESULT_CACHE RELIES_ON(item) IS
  -- Deklaracja zmiennej sterujcej kolekcji i zmiennej typu kolekcji. 
  counter      NUMBER  := 1;
  return_value STRINGS := strings();

  -- Definicja kursora z parametrami.
  CURSOR get_title
  ( partial_title VARCHAR2 ) IS
  SELECT   item_title
  FROM     item
  WHERE    UPPER(item_title) LIKE '%'||UPPER(partial_title)||'%';
BEGIN
  -- Odczyt danych i przypisywanie ich do kolekcji w ptli FOR opartej na kursorze.
  FOR i IN get_title(partial_title) LOOP
    return_value.EXTEND;
    return_value(counter) := i.item_title;
    counter := counter + 1;
  END LOOP;
  RETURN return_value;
END get_title;
/

list
show errors

DECLARE
  list STRINGS;
BEGIN
  list := get_title('Harry');
  FOR i IN 1..list.LAST LOOP
    dbms_output.put_line('list('||i||') : ['||list(i)||']');
  END LOOP;
END;
/
