/*
 * cursor_management.sql
 * Rozdzia 6., Oracle Database 11g. Programowanie w jzyku PL/SQL
 * Michael McLaughlin
 *
 * UWAGI:
 *
 * Ten skrypt tworzy funkcj, ktra zwraca
 * referencyjny system kursorowy ze sab kontrol typw.
 */

-- Uywane do diagnozowania skryptu.
SET ECHO ON
SET FEEDBACK ON
SET PAGESIZE 49999
SET SERVEROUTPUT ON SIZE 1000000

-- Definicja funkcji zwracajcej kursor referencyjny.
CREATE OR REPLACE FUNCTION get_full_titles
RETURN SYS_REFCURSOR IS
  titles SYS_REFCURSOR;
BEGIN
  OPEN titles FOR
  SELECT  item_title
  ,       item_subtitle
  FROM    item;
  RETURN titles;  
END;
/

DECLARE
  -- Definicja typu i deklaracja zmiennej.
  TYPE full_title_record IS RECORD
  ( item_title    item.item_title%TYPE
  , item_subtitle item.item_subtitle%TYPE);
  full_title FULL_TITLE_RECORD;
  
  -- Deklaracja zmiennej typu systemowego kursora referencyjnego.
  titles SYS_REFCURSOR;
BEGIN
  -- Przypisanie wyniku dziaania funkcji do kursora referencyjnego.
  titles := get_full_titles;

  -- Wywietlenie elementu kolekcji rwnolegej.
  LOOP
    FETCH titles INTO full_title;
    EXIT WHEN titles%NOTFOUND;
    dbms_output.put_line('Title ['||full_title.item_title||']');
  END LOOP;
END;
/
