/*
 * create_counting1.sql
 * Rozdzia 6., Oracle Database 11g. Programowanie w jzyku PL/SQL
 * Michael McLaughlin
 *
 * UWAGI:
 *
 * Ten skrypt tworzy funkcj counting uywajc parametru
 * w trybie IN OUT.
 */

-- Uywane do diagnozowania skryptu.
SET ECHO ON
SET FEEDBACK ON
SET PAGESIZE 49999
SET SERVEROUTPUT ON SIZE 1000000

CREATE OR REPLACE FUNCTION counting
( number_in IN OUT NUMBER ) RETURN VARCHAR2 IS
  TYPE numbers IS TABLE OF VARCHAR2(6);
  ordinal NUMBERS := numbers('Jeden','Dwa','Trzy','Cztery','Pi');
  retval VARCHAR2(14) := 'Nie znaleziono';
BEGIN
  -- Zastpowanie wartoci null w celu zapewnienia inkrementacji.
  IF number_in IS NULL THEN
    number_in := 1;
  END IF; 
  -- Powikszanie wartoci argument, jeli nie przekroczya okrelonego poziomu.
  IF number_in < 4 THEN
    retval := ordinal(number_in);
    number_in := number_in + 1;
  ELSE
    retval := ordinal(number_in);
  END IF;
  RETURN retval;
END;
/

DECLARE
  counter NUMBER := 1;
BEGIN
  FOR i IN 1..5 LOOP
    dbms_output.put('Licznik ['||counter||']');
    dbms_output.put_line('['||counting(counter)||']');
  END LOOP;
END;
/

CREATE OR REPLACE FUNCTION counting
( number_out OUT NUMBER ) RETURN VARCHAR2 IS
  TYPE numbers IS TABLE OF VARCHAR2(6);
  ordinal NUMBERS := numbers('Jeden','Dwa','Trzy','Cztery','Pi');
  retval VARCHAR2(14) := 'Nie znaleziono';
BEGIN
  -- Zastpowanie wartoci null w celu zapewnienia inkrementacji.
  IF number_out IS NULL THEN
    number_in := 1;
  END IF; 
  -- Powikszanie wartoci argument, jeli nie przekroczya okrelonego poziomu.
  IF number_out < 4 THEN
    retval := ordinal(number_out);
    number_in := number_in + 1;
  ELSE
    -- Ta instrukcja nigdy nie zostanie uruchomiona, poniewa number_out zawsze ma warto null.
    retval := ordinal(number_out);  
  END IF;
  RETURN retval;
END;
/


DECLARE
  counter NUMBER := 1;
BEGIN
  FOR i IN 1..5 LOOP
    dbms_output.put('Licznik ['||counter||']');
    dbms_output.put_line('['||counting(counter)||']');
  END LOOP;
END;
/
