/*
 * exception1.sql
 * Rozdzia 5., Oracle Database 11g. Programowanie w jzyku PL/SQL
 * Michael McLaughlin
 *
 * UWAGI:
 *
 * Ten skrypt tworzy procedur handle_errors.
 */

-- Uywane do diagnozowania skryptu.
SET ECHO ON
SET FEEDBACK ON
SET PAGESIZE 49999
SET SERVEROUTPUT ON SIZE 1000000

CREATE OR REPLACE PROCEDURE handle_errors
( object_name           IN        VARCHAR2
, module_name           IN        VARCHAR2 := NULL
, table_name            IN        VARCHAR2 := NULL
, sql_error_code        IN        NUMBER   := NULL
, sql_error_message     IN        VARCHAR2 := NULL
, user_error_message    IN        VARCHAR2 := NULL ) IS

  -- Definicja wyjtku lokalnego.
  raised_error          EXCEPTION;

  -- Definicja typu kolekcji i zainicjowanie zmiennej tego typu.
  TYPE error_stack IS TABLE OF VARCHAR2(80);
  errors                ERROR_STACK := error_stack();

  -- Definicja funkcji lokalnej sprawdzajcej typ obiektu.
  FUNCTION object_type
  ( object_name_in      IN        VARCHAR2 )
  RETURN VARCHAR2 IS
    return_type         VARCHAR2(12) := 'Nieokrelony';
  BEGIN
    FOR i IN ( SELECT   object_type
               FROM     user_objects
               WHERE    object_name = object_name_in ) LOOP
      return_type := i.object_type;
    END LOOP;
    RETURN return_type;
  END object_type;
BEGIN
  -- Przydzia pamici i przypisanie wartoci do kolekcji.
  errors.EXTEND;
  errors(errors.COUNT) := object_type(object_name)||' ['||object_name||']';

  -- Zastpowanie wartoci domylnych argumentami.
  IF module_name IS NOT NULL THEN
    errors.EXTEND;
    errors(errors.COUNT) := 'Nazwa moduu: ['||module_name||']';
  END IF;
  IF table_name IS NOT NULL THEN
    errors.EXTEND;
    errors(errors.COUNT) := 'Nazwa tabeli: ['||table_name||']';
  END IF;
  IF sql_error_code IS NOT NULL THEN
    errors.EXTEND;
    errors(errors.COUNT) := 'Warto funkcji SQLCODE: ['||sql_error_code||']';
  END IF;
  IF sql_error_message IS NOT NULL THEN
    errors.EXTEND;
    errors(errors.COUNT) := 'Warto funkcji SQLERRM: ['||sql_error_message||']';
  END IF;
  IF user_error_message IS NOT NULL THEN
    errors.EXTEND;
    errors(errors.COUNT) := user_error_message;
  END IF;

  errors.EXTEND;
  errors(errors.COUNT) := '----------------------------------------';
  RAISE raised_error;
EXCEPTION
  WHEN raised_error THEN
    FOR i IN 1..errors.COUNT LOOP
      dbms_output.put_line(errors(i));
    END LOOP;
    RETURN;
END;
/

