/*
 * parallel_collections.sql
 * Rozdzia 4., Oracle Database 11g. Programowanie w jzyku PL/SQL
 * Michael McLaughlin
 *
 * UWAGI:
 *
 * Ten skrypt ilustruje kolekcje rwnolege.
 */

-- Uywane do diagnozowania skryptu.
SET ECHO ON
SET FEEDBACK ON
SET PAGESIZE 49999
SET SERVEROUTPUT ON SIZE 1000000

DECLARE
  TYPE title_collection IS TABLE OF VARCHAR2(60);
  TYPE subtitle_collection IS TABLE OF VARCHAR2(60);
  title    TITLE_COLLECTION;
  subtitle SUBTITLE_COLLECTION;
BEGIN
  SELECT item_title
  ,      item_subtitle
  BULK COLLECT INTO title, subtitle
  FROM   item;
  -- Wywietla jeden element kolekcji rwnolegych.
  FOR i IN 1..title.COUNT LOOP
    dbms_output.put_line('Tytu ['||title(i)||']');
  END LOOP;
END;
/


















