/*
 * explicit_cursor2.sql
 * Rozdzia 4., Oracle Database 11g. Programowanie w jzyku PL/SQL
 * Michael McLaughlin
 *
 * UWAGI:
 *
 * Ten skrypt ilustruje kursory jawne.
 */

-- Uywane do diagnozowania skryptu.
SET ECHO ON
SET FEEDBACK ON
SET PAGESIZE 49999
SET SERVEROUTPUT ON SIZE 1000000

DECLARE
  TYPE item_record IS RECORD
  ( id     NUMBER
  , title  VARCHAR2(60));
  item ITEM_RECORD;
  CURSOR c IS
    SELECT  item_id
    ,       item_title
    FROM    item;
BEGIN
  OPEN c;
  LOOP
    FETCH c INTO item;
    EXIT WHEN c%NOTFOUND;
    dbms_output.put_line('Tytu ['||item.title||']');
  END LOOP;
END;
/













