/*
 * assoc_table.sql
 * Rozdzia 3., Oracle Database 11g. Programowanie w jzyku PL/SQL
 * Michael McLaughlin
 *
 * UWAGI:
 *
 * Ten skrypt ilustruje stosowanie kursorw referencyjnych.
 */

-- Uywane do diagnozowania skryptu.
SET ECHO ON
SET FEEDBACK ON
SET PAGESIZE 49999
SET SERVEROUTPUT ON SIZE 1000000

DECLARE
TYPE weakly_typed IS REF CURSOR;
quick WEAKLY_TYPED;
BEGIN
  OPEN quick FOR
    SELECT   item_title
    ,        COUNT(*)
    FROM     item
    HAVING  (COUNT(*) > 2)
    GROUP BY item_title;
  :refcur := quick;
END;
/








