/*
 * transaction_scope.sql
 * Rozdzia 2., Oracle Database 11g. Programowanie w jzyku PL/SQL
 * Michael McLaughlin
 *
 * UWAGI:
 *
 * Ten skrypt ilustruje tworzenie pojedynczego zasigu transakcji.
 */

-- Uywane do diagnozowania skryptu.
SET ECHO ON
SET FEEDBACK ON
SET PAGESIZE 49999
SET SERVEROUTPUT ON SIZE 1000000

BEGIN
  -- Utworzenie punktu zapisu.
  SAVEPOINT new_member;
  -- Pierwsza instrukcja INSERT.
  INSERT INTO member VALUES
  ( member_s1.nextval, 1005,'D921-71998','4444-3333-3333-4444', 1006
  , 2, SYSDATE, 2, SYSDATE);

  -- Druga instrukcja INSERT.
  INSERT INTO contact VALUES
  ( contact_s1.nextval, member_s1.currval + 1, 1003,
  ,'Jan','Kowalski',''
  , 2, SYSDATE, 2, SYSDATE);
  -- Wywietlanie informacji o powodzeniu i zatwierdzanie rekordw.
  dbsm_output.put_line('Obie operacje zakoczyy si sukcesem.');  
  COMMIT;
EXCEPTION
  WHEN others THEN
    -- Anulowanie operacji do punktu zapisu i wywietlenie informacji o wyjtku.
    ROLLBACK TO new_member;
    dbsm_output.put_line(SQLERRM);
END;
/

