/*
 * get_canonical_bfilename.sql
 * Dodatek D, Oracle Database 11g. Programowanie w jzyku PL/SQL
 * Michael McLaughlin
 *
 * UWAGI:
 *  - Ten skrypt wymaga do dziaania funkcji GET_DIRECTORY_PATH
 *    w schemacie SYSTEM.
 *  - Skrypt get_directory_path.sql tworzy potrzebn funkcj
 *    GET_DIRECTORY_PATH, przyznaje uprawnienia i tworzy synonimy.
 *
 * Ten skrypt tworzy funkcj skadowan, ktra zwraca ciek kanoniczn.
 * Jest to pena cieka i nazwa pliku na podstawie wartoci
 * kolumny typu BFILENAME.
 */

-- Suy do diagnozowania skryptu.
SET ECHO ON
SET FEEDBACK ON
SET PAGESIZE 49999
SET SERVEROUTPUT ON SIZE 1000000

CREATE OR REPLACE FUNCTION get_canonical_bfilename
( table_name        IN     VARCHAR2
, bfile_column_name IN     VARCHAR2
, primary_key       IN     VARCHAR2
, primary_key_value IN     VARCHAR2
, operating_system  IN     VARCHAR2 := 'WINDOWS')
RETURN VARCHAR2 IS

  -- Deklaracja domylnego ogranicznika.
  delimiter         VARCHAR2(1) := '\';

  -- Definicja zmiennej na instrukcj.
  stmt              VARCHAR2(200);

  -- Definicja lokalizatora.
  locator           BFILE;

  -- Definicja aliasu i nazwy pliku.
  dir_alias         VARCHAR2(255);
  directory         VARCHAR2(255);
  file_name         VARCHAR2(255);

  -- Definicja lokalnego wyjtku zwizanego z przekroczeniem rozmiaru.
  directory_num EXCEPTION;
  PRAGMA EXCEPTION_INIT(directory_num,-22285);  

BEGIN

  -- Dynamiczne przypisanie acucha znakw do instrukcji.
  stmt := 'BEGIN '
       || ' SELECT '||bfile_column_name||' '
       || ' INTO :column_value '
       || ' FROM  '||table_name||' '
       || ' WHERE '||primary_key||'='||''''||primary_key_value||''''||';'
       || 'END;';

  -- Uruchomienie dynamicznej instrukcji.
  EXECUTE IMMEDIATE stmt USING OUT locator;

  -- Sprawdzanie dostpnoci lokalizatora.
  IF locator IS NOT NULL THEN
    dbms_lob.filegetname(locator,dir_alias,file_name);
  END IF;

  -- Sprawdzanie systemu operacyjnego i zmiana ogranicznika, jeli jest to konieczne.
  IF operating_system <> 'WINDOWS' THEN
    delimiter := '/';
  END IF;
  
  -- Tworzenie kanonicznej nazwy pliku.
  file_name := get_directory_path(dir_alias) || delimiter || file_name;

  -- Zwracanie nazwy pliku.
  RETURN file_name;

EXCEPTION
  WHEN directory_num THEN
  RETURN NULL;

END get_canonical_bfilename;
/
