// --------------------------------------------------------------------
// QueryTable.java
// Dodatek D, Oracle Database 11g. Programowanie w jzyku PL/SQL
// Michael McLaughlin
//
// Ten kod ilustruje wczytywanie zmiennych skalarnych do tabeli JTable.
// --------------------------------------------------------------------

// Importowanie klas na potrzeby aplikacji w jzyku Java.
import java.awt.Component;
import java.awt.Dimension;
import java.awt.image.BufferedImage;
import java.awt.GridLayout;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;

// Importowanie oglnych klas do obsugi JDBC.
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;

// Importowanie klas Oracle.
import oracle.jdbc.driver.OracleDriver;
import oracle.jdbc.pool.OracleDataSource;

// Doczenie bibliotek opisanych w ksice (dostpnych w witrynie wydawnictwa).
import plsql.fileio.FileIO;
import plsql.jdbc.DataConnectionPane;
import plsql.jdbc.DataTablePane;
// -------------------------------------------------------------------/
public class QueryTable extends JFrame {
  // Definiowanie poczenia z baz danych.
  private String host;
  private String port;
  private String dbname;
  private String userid;
  private String passwd;

  // Definicja zmiennej na potrzeby zapytania.
  private String tableName;

  // Definicja panelu do tworzenia poczenia z baz danych. 
  private DataConnectionPane message = new DataConnectionPane();
  private DataTablePane table = new DataTablePane(DataTablePane.TABLE_COLUMN_ALL);

  // Kod klasy.
  public QueryTable (String s) {
    super(s);

    // Pobranie wartoci poczenia z baz danych lub zakoczenie dziaania programu.
    if (JOptionPane.showConfirmDialog(this,message
         ,"Podaj wartoci acucha znakw poczenia z Oracle"
         ,JOptionPane.OK_CANCEL_OPTION) == 0) {

    // Ustawienie zmiennych poczenia.
    host = message.getHost();
    port = message.getPort();
    dbname = message.getDatabase();
    userid = message.getUserID();
    passwd = message.getPassword();

    // Wywietlenie informacji o poczeniu w oknie konsoli (narzdzie diagnostyczne).
    message.getConnection();

    // Pobieranie parametrw zapytania.
    if (JOptionPane.showConfirmDialog(this,table
         ,"Podaj wartoci acucha znakw poczenia z Oracle"
         ,JOptionPane.OK_CANCEL_OPTION) == 0) {

        // Ustawienie zmiennych zapytania. 
        tableName = table.getTableName();

        // Utworzenie panelu JPanel w celu wywietlenia danych.
        ManageTable panel = new ManageTable();

        // Konfigurowanie panelu JPanel.
        panel.setOpaque(true);
        setContentPane(panel);

        // Konfigurowanie ramki JFrame.
        setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
        setLocation(100,100);
        pack();
        setVisible(true); }
      else
        System.exit(1); }
    // --------------------------------------------------------/
    private class ManageTable extends JPanel {
      // Definicje tabeli docelowej i zmiennej na rozmiar wiersza zwracanego przez zapytanie.
      private String target = tableName;
      private int querySize = 0;

      // Definicje kontenerw.
      private Object[][] data = getQuery(host,port,dbname,userid,passwd,target);
      private Object[][] cells = getData();
      private Object[] columns = getColumnHeaders();

      // Definicje wywietlanych zmiennych.
      private JTable table = new JTable(cells,columns);
      private JScrollPane scrollPane;
      private TableModel tableModel;
      // -----------------------------------------------------------------/
  public ManageTable () {
    super(new GridLayout(1,0));
    decorate(300,100); }
  // -----------------------------------------------------------------/
  private String[] getColumnHeaders() {
    // Okrelanie rozmiaru kontenera, kopiowanie nagwkw kolumn i zwracanie danych.
    String[] headers = new String[data[0].length];
    for (int i = 0;i < data[0].length;i++)
      headers[i] = (String) data[0][i];
    return headers; }
  // -----------------------------------------------------------------/
  private Object[][] getData() {
    // Okrelanie rozmiaru kontenera, kopiowanie komrek i zwracanie danych.
    Object[][] cells = new Object[querySize][];
    for (int i = 0;i < querySize;i++) {
      cells[i] = new Object[data[i + 1].length];
      for (int j = 0;j < data[i + 1].length;j++)
        cells[i][j] = data[i + 1][j]; }
    return cells; }
  // -----------------------------------------------------------------/
  private void decorate (int width, int height) {
    // Konfigurowanie panelu JPanel.
    setSize(width,height);

    // Konfigurowanie i inicjowanie tabeli JTable.
    table.setPreferredScrollableViewportSize(new Dimension(width,height));
    table.setFillsViewportHeight(true);
    initColumns(table);

    // Dodawanie panelu JScrollPane.
    scrollPane = new JScrollPane(table);
    add(scrollPane); }
  // -----------------------------------------------------------------/
  private void initColumns(JTable table) {
    // Inicjowanie szerokoci komrek.
    int headerWidth = 0;
    int cellWidth = 0;

    // Definiowanie zmiennych do obsugi wywietlania.
    Component component = null;
    TableColumn tableColumn = null;
    TableCellRenderer headerRenderer =
      table.getTableHeader().getDefaultRenderer();

    // Inicjowanie klasy TableModel.
    tableModel = table.getModel();

    // Inicjowanie kolumn.
    for (int i = 0;i < table.getColumnCount();i++)
      tableColumn = table.getColumnModel().getColumn(i); }
  // -----------------------------------------------------------------/
  private Object[][] getQuery(String host,String port,String dbname
                             ,String user,String pswd,String table) {
    // Definiowanie kontenera na zwracane dane.
    Object[][] dataset = null;
    String[] datatype = null;

    try {
      // Wczytywanie sterownikw oraz inicjowanie poczenia, metadanych i instrukcji.
      OracleDataSource ods = new OracleDataSource();
      String url = "jdbc:oracle:thin:@//"+host+":"+port+"/"+dbname;
      ods.setURL(url);
      ods.setUser(userid);
      ods.setPassword(passwd);
      Connection conn = ods.getConnection();
      DatabaseMetaData dmd = conn.getMetaData();
      Statement stmt = conn.createStatement();

      // Deklarowanie zbioru wynikw, inicjowanie zbioru danych i zamykanie zbioru wynikw.
      ResultSet rset = stmt.executeQuery("SELECT COUNT(*) FROM " + table);
      while (rset.next())
        dataset = new Object[rset.getInt(1) + 1][];
      rset.close();

      // Ponowne uycie zbioru wynikw i pobranie zwizanych z nim metadanych.
      rset = stmt.executeQuery("SELECT * FROM " + table);
      ResultSetMetaData rsmd = rset.getMetaData();

      // Deklaracja licznika wierszy.
      int row = 0;

      // Okrelanie rozmiaru tablicy.
      dataset[row] = new Object[rsmd.getColumnCount()];
      datatype = new String[rsmd.getColumnCount()];

      // Przypisywanie etykiet i typw kolumn.
      for (int col = 0;col < rsmd.getColumnCount();col++) {
        dataset[row][col] = rsmd.getColumnName(col + 1);
        datatype[col] = rsmd.getColumnTypeName(col + 1); }

      // Okrelanie rozmiaru tablic zagniedonych i przypisywanie wartoci kolumn do wierszy.
      while (rset.next()) {
        dataset[++row] = new Object[rsmd.getColumnCount()];
        for (int col = 0;col < rsmd.getColumnCount();col++)
          if (datatype[col] == "DATE")
            dataset[row][col] = rset.getDate(col + 1);
          else if (datatype[col] == "NUMBER")
            dataset[row][col] = rset.getLong(col + 1);
          else if (datatype[col] == "VARCHAR2")
            dataset[row][col] = rset.getString(col + 1); }}

      // Zapisanie liczby wierszy zwrconych przez zapytanie.
      querySize = row;

      // Zamknicie zasobw.
      rset.close();
      stmt.close();
      conn.close();

      // Zwrcenie danych.
      return dataset; }
    catch (SQLException e) {
      // Sprawdzanie i zwracanie bdw poczenia oraz bdw w kodzie SQL.
      if (e.getSQLState() == null) {
        System.out.println(
            new SQLException("Bd uproszczonego klienckiego poczenia Oracle Net8.",
                      "ORA-" + e.getErrorCode() +
                      ": Bdne argumenty uproszczonego klienta Net8:\n\n" +
                      "  nazwa serwera [" + host + "]\n" +
                      "  numer portu   [" + port + "]\n" +
                      "  nazwa bazy    [" + db + "]\n",
                      e.getErrorCode()).getSQLState()); }
        return dataset; }
      else {
        System.out.println(e.getMessage());
        return dataset; }}}
  // -----------------------------------------------------------------/
  public static void main(String[] args) {
    // Definicja okna.
    JFrame frame = new JFrame("Zapytanie do tabeli"); }}