/*
 * HelloWorldThin.java
 * Dodatek D, Oracle Database 11g. Programowanie w jzyku PL/SQL
 * Michael McLaughlin
 *
 * Ten skrypt tworzy niezaleny program w jzyku Java.
 */

// Importowanie klas.
import java.io.IOException;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;

// Importowanie klas Oracle.
import oracle.jdbc.driver.OracleDriver;
import oracle.jdbc.pool.OracleDataSource;
// ------------------------------------------------------/
public class HelloWorldThin {
  // Definicja zmiennej statycznej typu String.
  private static String user;

  // --------------------------------------------------/
  private static void printLine() {
    printLine(null); }
  // --------------------------------------------------/
  private static void printLine(String s) {
    if (s != null) {
      System.out.println(s); }

    // Wywietlanie linii.
    System.out.print  ("---------------------------------------");
    System.out.println("---------------------------------------"); }
  // --------------------------------------------------/
  private static String readEntry() {
    try {

      // Definicje zmiennych metody.
      int c;
      StringBuffer buffer = new StringBuffer();

      // Wczytanie pierwszego znaku.
      c = System.in.read();

      // Wczytanie pozostaych znakw.
      while (c != '\n' && c != -1) {
        buffer.append((char) c);
        c = System.in.read(); }

      // Zwrcenie zawartoci bufora.
      return buffer.toString().trim(); }
    catch (IOException e) {
      return null; }}
  // ----------------------------------------------------/
  public static void main(String args[]) throws SQLException, IOException  {
    // Definicje zmiennych metody.
    boolean debug = false;
    int slashIndex;
    String userIn;
    String password;
    String host;
    String port;
    String db;
    String debugString = new String("DEBUG");

    // Wywietlanie linii.
    printLine();

    // Sprawdzanie i wywietlanie informacji o trybie diagnozowania.
    if (args.length > 0) {
      if (args[0].toUpperCase().equals(debugString)) {
        debug = true;
        printLine("Tryb diagnozowania jest wczony."); }
      else {
        for (int i = 0;i < args.length;i++) {
          System.out.println("Niepoprawne argumenty: [" + args[i] + "]"); }

        // Wywietlanie linii i komunikatu.
        printLine();
        printLine("Prawidowa nazwa argumentu to: DEBUG."); }}

    // Wywietlanie monitu o dane uwierzytelniajce, a nastpnie wczytywanie i zapisywanie ich.
    System.out.print("Podaj nazw uytkownika [UID/HASO]: ");

    // Wczytywanie danych wyjciowych.
    userIn = readEntry();

    // Przetwarzanie nazwy uytkownika i hasa oraz sprawdzanie zgodnoci midzy nimi.
    slashIndex = userIn.indexOf("/");
    if (slashIndex != -1) {
      user = userIn.substring(0, slashIndex);
      password = userIn.substring(slashIndex + 1); }
    else {
      user = userIn;
      System.out.print("Podaj haso: ");
      password = readEntry(); }

    // Wywietlanie monitu o nazw serwera, a nastpnie wczytywanie i zapisywanie jej.
    System.out.print("Podaj nazw serwera: ");
    host = readEntry();

    // Wywietlanie monitu o numer portu, a nastpnie wczytywanie i zapisywanie go.
    System.out.print("Podaj numer portu: ");
    port = readEntry();

    // Wywietlanie monitu o nazw bazy danych, a nastpnie wczytywanie i zapisywanie jej.
    System.out.print("Podaj nazw bazy danych: ");
    db = readEntry();

    // Wywietlanie linii i komunikatu.
    printLine("Nawizywanie poczenia z baz danych...");
    printLine("jdbc:oracle:oci8:@" +
               host + ":" + port + ":" + db + "," +
               user + "," + passwd);

    // Prba nawizania poczenia.
    try {
      // Ustawianie rdowej puli pocze.
      OracleDataSource ods = new OracleDataSource();
      String url = "jdbc:oracle:thin:@//" + host + ":" + port + "/" + db;
      ods.setURL(url);
      ods.setUser(user);
      ods.setPassword(passwd);

      // Definicja poczenia.
      Connection conn = ods.getConnection();

      // Sygnalizowanie nawizania poczenia.
      printLine("Uzyskano poczenie.");

      // Definiowanie obiektu metadanych i wywietlanie komunikatu.
      DatabaseMetaData dmd = conn.getMetaData();
      printLine("Wersja sterownika: [" + dmd.getDriverVersion() + "]\n" +
                "Nazwa sterownika:  [" + dmd.getDriverName() + "]");

      // Tworzenie i wykonywanie instrukcji.
      Statement stmt = conn.createStatement();
      ResultSet rset = stmt.executeQuery("SELECT 'Witaj, wiecie.' FROM dual");

      // Wczytywanie zwrconych wierszy.
      while (rset.next()) {
        printLine(rset.getString(1)); }

      // Zamykanie zbioru wynikw.
      rset.close();
      stmt.close();
      conn.close();

      // Wywietlanie linii i komunikatu.
      printLine("Poczenie JDBC dziaa poprawnie."); }
    catch (SQLException e) {
      if (debug) {
        e.printStackTrace();
        printLine(); }
      else {
        if (e.getSQLState() == null) {
          System.out.println(
            new SQLException("Bd uproszczonego klienckiego poczenia Oracle Net8.",
                      "ORA-" + e.getErrorCode() +
                      ": Bdne argumenty uproszczonego klienta Net8:\n\n" +
                      "  nazwa serwera [" + host + "]\n" +
                      "  numer portu   [" + port + "]\n" +
                      "  nazwa bazy    [" + db + "]\n",
                      e.getErrorCode()).getSQLState()); }
        else {
          // Usuwanie doczonej sekwencji "\n".
          printLine(e.getMessage().substring(0,e.getMessage().length() - 1)); }}

      // Wywietlenie linii i komunikatu.
      printLine("Nieudana prba nawizania poczenia JDBC."); }}}
