<html>
<! UploadBioSQL.php                                               >
<! Dodatek C, Oracle Database 11g. Programowanie w jzyku PL/SQL  >
<! Michael McLaughlin                                             >
<!                                                                >
<! Ten skrypt ilustruje przesyanie pliku, przenoszenie go,       >
<! zapisywanie zawartoci w kolumnie typu CLOB za pomoc          >
<! instrukcji UPDATE jzyka SQL, uzyskiwanie dostpu do           >
<! danych zapisanych w bazie i wywietlanie strony.               >
<head>
<title>
  Dodatek C. UploadBioSQL.php
</title>
<style>
.e {background-color: #ccccff; font-weight: bold; color: #000000;}
.v {background-color: #cccccc; color: #000000;}
</style>
</head>
<body>
<?php
  // Wywietlanie przeniesionego pliku na stronie internetowej.
  $biography = process_uploaded_file();

  // Sprawdzanie moliwoci nawizania poczenia z baz danych.
  if ($c = @oci_connect("php","php","xe"))
  {
    // Deklaracje zmiennych wejciowych.
    (isset($_POST['id'])) ? $id = (int) $_POST['id'] : $id = 1;
    (isset($_POST['name'])) ? $name = $_POST['name'] : $name = "Washington";

    // Deklaracja polecenia w jzyku PL/SQL.
    $stmt = "UPDATE    president
             SET       biography = empty_clob()
             WHERE     president_id = :id
             RETURNING biography
             INTO      :descriptor";

    // Usuwanie znakw specjalnych w celu uniknicia bdw ORA-6550 i PLS-00103.
    $stmt = strip_special_characters($stmt);

    // Parsowanie zapytania za pomoc poczenia.
    $s = oci_parse($c,$stmt);

    // Definicja deskryptora typu CLOB.
    $rlob = oci_new_descriptor($c,OCI_D_LOB);

    // Definicja nazwy zmiennej odpowiadajcej deskryptorowi typu CLOB.
    oci_define_by_name($s,':descriptor',$rlob,SQLT_CLOB);

    // Wizanie zmiennych jzyka PHP z typami bibliotek OCI.
    oci_bind_by_name($s,':id',$id);
    oci_bind_by_name($s,':descriptor',$rlob,-1,SQLT_CLOB);

    // Wykonywanie instrukcji jzyka PL/SQL.
    if (oci_execute($s,OCI_DEFAULT))
    {
       $rlob->save($biography);
       oci_commit($c);
       query_insert($id,$name);
    }

    // Zamknicie poczenia z baz danych.
    oci_close($c);
  }
  else
  {
    // Przypisanie bdu OCI i formatowanie cudzysoww oraz apostrofw.
    $errorMessage = oci_error();
    print htmlentities($errorMessage['message'])."<br />";
  }

  // Pobieranie zaktualizowanego rekordu.
  function query_insert($id,$name)
  {
    // Sprawdzanie moliwoci nawizania poczenia z baz danych.
    if ($c = @oci_new_connect("php","php","xe"))
    {
      // Deklaracja instrukcji SELECT jzyka SQL zwracajcej dane typu CLOB.
      $stmt = "SELECT   biography
               FROM     president
               WHERE    president_id = :id";

      // Parsowanie zapytania za pomoc poczenia.
      $s = oci_parse($c,$stmt);

      // Powizanie zmiennych jzyka PHP z typami bibliotek OCI.
      oci_bind_by_name($s,':id',$id);

      // Wykonywanie instrukcji jzyka PL/SQL.
      if (oci_execute($s))
      {
        // Pobranie wartoci w postaci deskryptora typu LOB.
        while (oci_fetch($s))
        {
          for ($i = 1;$i <= oci_num_fields($s);$i++)
            if (is_object(oci_result($s,$i)))
            {
              if ($size = oci_result($s,$i)->size())
                $data = oci_result($s,$i)->read($size);
              else
                $data = "&nbsp;";
            }
            else
            {
              if (oci_field_is_null($s,$i))
                $data = "&nbsp;";
              else
                $data = oci_result($s,$i);
            }
        } // Koniec ptli while(oci_fetch($s)).

        // Formatowanie tabeli HTML w celu wywietlenia biografii.
        $out = '<table border="1" cellpadding="3" cellspacing="0">';
        $out .= '<tr>';
        $out .= '<td align="center" class="e">'.$name.' - biografia</td>';
        $out .= '</tr>';
        $out .= '<tr>';
        $out .= '<td class="v">'.$data.'</td>';
        $out .= '</tr>';
        $out .= '</table>';
      }

      // Wywietlanie tabeli HTML.
      print $out;

      // Zamknicie poczenia z baz danych.
      oci_close($c);
    }
    else
    {
      // Przypisanie bdu OCI error oraz formatowanie cudzysoww i apostrofw.
      $errorMessage = oci_error();
      print htmlentities($errorMessage['message'])."<br />";
    }
  }

  // Zarzdza przesyaniem pliku i zwraca jego zawarto jako acuch znakw.
  function process_uploaded_file()
  {
    // Deklaracja zmiennej do przechowywania zawartoci pliku.
    $contents = "";

    // Definicja nazwy przesyanego pliku na potrzeby systemw Windows i Linux.
    if (ereg("Win32",$_SERVER["SERVER_SOFTWARE"]))
      $upload_file = getcwd()."\\temp\\".$_FILES['userfile']['name'];
    else
      $upload_file = getcwd()."/temp/".$_FILES['userfile']['name'];

    // Sprawdzanie dostpnoci i przenoszenie przesanego pliku.
    if (is_uploaded_file($_FILES['userfile']['tmp_name']))
      move_uploaded_file($_FILES['userfile']['tmp_name'],$upload_file);

    // Otwarcie uchwytu pliku i stumienie bdw niedostpnoci pliku.
    if ($fp = @fopen($upload_file,"r"))
    {
      // Wczytywanie danych do momentu dojcia do znacznika koca pliku.
      while (!feof($fp))
        $contents .= fgetc($fp);

      // Zamknicie otwartego uchwytu pliku.
      fclose($fp);
    }

    // Zwrcenie zawartoci pliku jako acucha znakw.
    return $contents;
  }

  // Usuwa znaki specjalne, na przykad przejcia do nowego wiersza lub tabulacji.
  function strip_special_characters($str)
  {
    $out = "";
    for ($i = 0;$i < strlen($str);$i++)
      if ((ord($str[$i]) != 9) && (ord($str[$i]) != 10) &&
          (ord($str[$i]) != 13))
        $out .= $str[$i];

    // Zwracanie wstpnie przetworzonej instrukcji jzyka SQL.
    return $out;
  }
?>

</body>
</html>