/*
 * HelloWorld4.sql
 * Rozdzia 15., Oracle Database 11g. Programowanie w jzyku PL/SQL
 * Michael McLaughlin
 *
 * UWAGI:
 *
 * Ten skrypt tworzy nakadk jzyka PL/SQL na plik klasy jzyka Java.
 */

-- Uywane do diagnozowania skryptu.
SET ECHO ON
SET FEEDBACK ON
SET PAGESIZE 49999
SET SERVEROUTPUT ON SIZE 1000000

-- Typ obiektowy, ktry peni funkcj nakadki na klas jzyka Java.
CREATE OR REPLACE TYPE hello_world4 AS OBJECT
EXTERNAL NAME 'HelloWorld4' LANGUAGE JAVA
USING SQLData
( instanceName VARCHAR2(100) EXTERNAL NAME 'java.lang.String'
, CONSTRUCTOR FUNCTION hello_world4
  RETURN SELF AS RESULT
, MEMBER FUNCTION getQualifiedName
  RETURN VARCHAR2 AS LANGUAGE JAVA
  NAME 'HelloWorld4.getQualifiedName() return java.lang.String'
, MEMBER FUNCTION getSQLTypeName
  RETURN VARCHAR2 AS LANGUAGE JAVA
  NAME 'HelloWorld4.getSQLTypeName() return java.lang.String' )
INSTANTIABLE FINAL;
/

-- Blok anonimowy do testowania typu.
DECLARE

  -- Definiowanie i tworzenie egzemplarzy typu obiektowego.
  my_obj1 hello_world4 := hello_world4('Adam');
  my_obj2 hello_world4 := hello_world4('Eve');
  
BEGIN

  -- Testowanie egzemplarza klasy.
  dbms_output.put_line('Element nr 1: ['||my_obj1.getQualifiedName||']');
  dbms_output.put_line('Element nr 2: ['||my_obj2.getQualifiedName||']');
  dbms_output.put_line('Element nr 3: ['||my_obj1.getSQLTypeName||']');
  dbms_output.put_line('Element nr 4: ['||my_obj1.getSQLTypeName||']');
  
  -- Testowanie repozytorium metadanych za pomoc pakietu DBMS_JAVA.
  dbms_output.put_line(
    'Element nr 5: ['||user||'.'||dbms_java.longname('HELLO_WORLD4')||']');

END;
/