/*
 * HelloWorld4.java
 * Rozdzia 15., Oracle Database 11g. Programowanie w jzyku PL/SQL
 * Michael McLaughlin
 *
 * UWAGI:
 *
 * Ten skrypt tworzy wewntrzn (serwerow) klas jzyka Java,
 * umoliwiajc tworzenie egzemplarzy.
 * Pobiera ona dane z lokalnego egzemplarza bazy.
 */

// Importowane klasy Oracle.
import java.sql.*;
import java.io.*;
import oracle.sql.*;
import oracle.jdbc.*;
import oracle.jdbc.oracore.*;

// Definicja klasy.
public class HelloWorld4 implements SQLData {
  // Definicje i deklaracje komponentw interfejsu SQLData.
  private String className = new String("HelloWorld4.class");
  private String instanceName;
  private String qualifiedName;
  private String sql_type;

  public HelloWorld4() {
    String user = new String();

    try {
      user = getUserName(); }
    catch (Exception e) {}

    qualifiedName = user + "." + className; }

  // Definicja metody zwracajcej pen nazw. 
  public String getQualifiedName() throws SQLException {
    return this.qualifiedName + "." + instanceName; }

  // Definicja metody zwracajcej nazw obiektu bazy danych.
  public String getSQLTypeName() throws SQLException {
    // Zwraca nazw typu zdefiniowanego przez uytkownika lub nazw obiektu bazy danych.
    return sql_type; }

  // Definicja metody kierujcej zapytanie do egzemplarza.
  public String getUserName() throws SQLException {
    String userName = new String();
    String getDatabaseSQL = "SELECT user FROM dual";

    // Deklaracja poczenia z baz danych Oracle.
    Connection conn = DriverManager.getConnection("jdbc:default:connection:");

    // Deklaracja przygotowanej instrukcji, uruchomienie zapytania i wczytanie wynikw.
    PreparedStatement ps = conn.prepareStatement(getDatabaseSQL);
    ResultSet rs = ps.executeQuery();
    while (rs.next()) {
      userName = rs.getString(1); }

    return userName; }

  // Implementacja metody readSQL() interfejsu SQLData.
  public void readSQL(SQLInput stream, String typeName) throws SQLException {
    // Definicja zmiennej sql_type do wczytywania danych wejciowych i sygnalizowania przecionych sygnatur.
    sql_type = typeName;

    // Przesanie wartoci do klasy.
    instanceName = stream.readString(); }

  // Implementacja metody readSQL() interfejsu SQLData.
  public void writeSQL(SQLOutput stream) throws SQLException {
    // Zwracanie wartoci przy uyciu funkcji obiektu stream.
    stream.writeString('variable_name');  }
}

