/*
 * HelloWorld2.sql
 * Rozdzia 15., Oracle Database 11g. Programowanie w jzyku PL/SQL
 * Michael McLaughlin
 *
 * UWAGI:
 *
 * Ten skrypt tworzy nakadk jzyka PL/SQL na plik klasy jzyka Java.
 */

-- Uywane do diagnozowania skryptu.
SET ECHO ON
SET FEEDBACK ON
SET PAGESIZE 49999
SET SERVEROUTPUT ON SIZE 1000000

-- Tworzy pakiet-nakadk jzyka PL/SQL na plik klasy jzyka Java.
CREATE OR REPLACE PACKAGE hello_world2 AS

  -- Definicja funkcji bezargumentowej.
  FUNCTION hello
  RETURN VARCHAR2;
  
  -- Definicja funkcji jednoargumentowej.
  FUNCTION hello
  ( who  VARCHAR2 )
  RETURN VARCHAR2;
  
END hello_world2;
/

-- Tworzy pakiet-nakadk jzyka PL/SQL na plik klasy jzyka Java.
CREATE OR REPLACE PACKAGE BODY hello_world2 AS

  -- Definicja funkcji bezargumentowej.
  FUNCTION hello
  RETURN VARCHAR2 IS
  LANGUAGE JAVA
  NAME 'HelloWorld2.hello() return String';
  
  -- Definicja funkcji jednoargumentowej.
  FUNCTION hello
  ( who  VARCHAR2 )
  RETURN VARCHAR2 IS
  LANGUAGE JAVA
  NAME 'HelloWorld2.hello(java.lang.String) return String';
  
END hello_world2;
/

COL object_name   FORMAT A30
COL object_type   FORMAT A12
COL object_status FORMAT A7

-- Pobieranie obiektw
SELECT   object_name
,        object_type
,        status
FROM     user_objects
WHERE    object_name IN ('HelloWorld2','HELLO_WORLD2');

-- Testowanie klasy jzyka Java za pomoc nakadki jzyka PL/SQL.
SELECT   hello_world2.hello('Paul McCartney')
FROM     dual;