/*
 * create_library2.sql
 * Rozdzia 13., Oracle Database 11g. Programowanie w jzyku PL/SQL
 * Michael McLaughlin
 *
 * UWAGI:
 *
 * Ten skrypt pokazuje, jak utworzy bibliotek do obsugi
 * procedur zewntrznych. Wi si z tym pewne ograniczenia,
 * ktre trzeba pozna:
 *  - Mona utworzy t bibliotek bez wczeniejszego przygotowania
 *    biblioteki wspdzielonej, a system nie zgosi bdu. Baza danych
 *    dziaa wedug zaoenia, e programista doda odpowiedni plik
 *    przed rozpoczciem korzystania z biblioteki.
 *  - Ten kod naley skompilowa do biblioteki wspdzielonej w systemie UNIX
 *    (rozszerzenie *.so) lub do biblioteki doczanej dynamicznie
 *    (*.DLL) w systemie Windows.
 *  - W systemie UNIX bibliotek wspdzielon mona skompilowa
 *    na dwa sposoby. Podejmy je poniej:
 *    - Solaris: gcc -G -o sample.so sample.c
 *    - GNU:     gcc -shared -o sample.so sample.c
 *  - Zakadamy, e rodowisko IDE Microsoftu jest dobrze zaprojektowane
 *    i zawiera wiadmoci pomocne w kompilacji biblioteki DLL.
 */

SET ECHO ON
SET SERVEROUTPUT ON SIZE 1000000

ACCEPT filedir PROMPT "Podaj katalog biblioteki: "

-- Definicja zmiennej powizanej sesji
VARIABLE directory VARCHAR2(255)

-- Blok anonimowy gwarantujcy, e klucz gwny nie zosta naruszony
BEGIN
  -- Jeli kod wykryje wiersz, usuwa go w ptli
  FOR i IN (SELECT   null
            FROM     user_libraries
            WHERE    library_name = 'library_write_string') LOOP

    EXECUTE IMMEDIATE 'DROP LIBRARY library_write_string';

  END LOOP;

END;
/

DECLARE

  -- Definicje zmiennych do tworzenia polece
  cmd  VARCHAR2(255)  := 'CREATE OR REPLACE LIBRARY ';
  int  VARCHAR2(5)    := ' AS ''';
  dir  VARCHAR2(100)  := '/tmp'; -- W Windows domylnie 'C:\TEMP'
  ext  VARCHAR2(4)    := '.so''';
  file VARCHAR2(30)   := 'writestr1';
  lib  VARCHAR2(30)   := 'library_write_string';
  
BEGIN

  -- Sprawdzanie, czy przekazano argument
  IF '&filedir' IS NOT NULL OR
      dir IS NOT NULL THEN

    -- Przypisywanie argumentu do zmiennej okrelajcej katalog
    IF '&filedir' IS NOT NULL THEN
      IF INSTR('&filedir','$') = 0 THEN
        dir := '&filedir';
      ELSE
        dbms_output.put_line('Hej');
      END IF;
    END IF;

    -- Przypisywanie wartoci do zmiennej powizanej sesji
    :directory := dir;

    -- Tworzenie polecenia
    cmd := cmd || lib || int || dir || '/' || file || ext; 
  
    -- Wywietlanie nagwka i polecenia
    DBMS_OUTPUT.PUT_LINE('Wywolane polecenie:');
    DBMS_OUTPUT.PUT_LINE('---------------');
    DBMS_OUTPUT.PUT_LINE(cmd);

    /*
    || Przykad polecenia utworzonego w celu wykonania go jako instrukcji DNS
    || ================================================
    || CREATE OR REPLACE LIBRARY library_write_string AS
    || '<oracle_home_directory>/<custom_library>/<file_name>.<file_ext>';
    || /
    */

    -- Wykonanie polecenia
    EXECUTE IMMEDIATE cmd;

  END IF;

END;
/

BEGIN

  -- Wywietlanie nagwka
  DBMS_OUTPUT.PUT_LINE('Znalezione biblioteki:');
  DBMS_OUTPUT.PUT_LINE(
    '----------------------------------------');

  -- Odczyt wszystkich bibliotek uytkownika
  FOR i IN (SELECT   library_name c1
            ,        file_spec c2
            ,        dynamic c3
            ,        status c4
            FROM     user_libraries) LOOP

    -- Wywietlanie kolumn jako wierszy
    DBMS_OUTPUT.PUT_LINE('Library_Name: ['||i.c1||']');
    DBMS_OUTPUT.PUT_LINE('File_Spec   : ['||i.c2||']');
    DBMS_OUTPUT.PUT_LINE('Dynamic     : ['||i.c3||']');
    DBMS_OUTPUT.PUT_LINE('Status      : ['||i.c4||']');

    -- Wiersz rozdzielajcy
    DBMS_OUTPUT.PUT_LINE(
      '----------------------------------------');

  END LOOP;

END;
/

CREATE OR REPLACE PROCEDURE write_string
  (path      VARCHAR2
  ,message   VARCHAR2) AS EXTERNAL
LIBRARY library_write_string
NAME "writestr2"
PARAMETERS
  (path      STRING
  ,message   STRING);
/

show errors

DECLARE

  -- Definicja wyjtku informujcego o nieprawidowej ciece DLL
  bad_dll_path EXCEPTION;
  PRAGMA EXCEPTION_INIT(bad_dll_path,-28595);

  -- Definicja wyjtku informujcego o braku pliku
  missing_file EXCEPTION;
  PRAGMA EXCEPTION_INIT(missing_file,-6520);

BEGIN

  -- Wywoanie biblioteki zewntrznej
  write_string('/tmp/file.txt','Witaj, swiecie!');

EXCEPTION

  -- Przetwarzanie nieprawidowej cieki do pliku DLL
  WHEN bad_dll_path THEN
    DBMS_OUTPUT.PUT_LINE('Niepoprawna sciezka do katalogu '||:directory||'.');
    RETURN;

  -- Przetwarzanie bdu braku pliku
  WHEN missing_file THEN
    DBMS_OUTPUT.PUT_LINE('Brak biblioteki w katalogu '||:directory||'.');
    RETURN;

END;
/
