/*
 * use_messenger.sql
 * Rozdzia 12., Oracle Database 11g. Programowanie w jzyku PL/SQL
 * Michael McLaughlin
 *
 * UWAGI:
 *
 * Ten skrypt demonstruje wykorzystanie pakietu MESSENGER jako nakadki
 * na pakiet DBMS_PIPE
 */

-- Uywane do diagnozowania skryptu.
SET ECHO ON
SET FEEDBACK ON
SET PAGESIZE 49999
SET SERVEROUTPUT ON SIZE 1000000

DECLARE

  -- Definicja lokalnej funkcji pakietu zwracajcej nazw uytkownika
  FUNCTION get_user 
    RETURN VARCHAR2 IS

  BEGIN

    -- Kursorowa ptla for suy do zwrcenia nazwy uytkownika 
    FOR i IN (SELECT user FROM dual) LOOP

      -- Zwracanie nazwy uytkownika 
      return i.user;

    END LOOP;
 
  END get_user;
  
BEGIN

  -- Wysyanie komunikatu 
  IF (MESSENGER.SEND_MESSAGE(get_user,'Witaj, swiecie!') = 0) THEN

    -- Pobieranie i wywietlanie komunikatu
    DBMS_OUTPUT.PUT_LINE(MESSENGER.RECEIVE_MESSAGE);

  END IF;

END;
/
