/*
 * read_message.sql
 * Rozdzia 12., Oracle Database 11g. Programowanie w jzyku PL/SQL
 * Michael McLaughlin
 *
 * UWAGI:
 *
 * Ten skrypt pobiera dane z bufora lokalnego
*/

-- Uywane do diagnozowania skryptu.
SET ECHO ON
SET FEEDBACK ON
SET PAGESIZE 49999
SET SERVEROUTPUT ON SIZE 1000000

DECLARE

  message VARCHAR2(30 CHAR) := NULL;
  success INTEGER;

BEGIN

  success := DBMS_PIPE.RECEIVE_MESSAGE('ORA$PIPE$00F3B7B50001',1);

  IF (success = 0) THEN
    DBMS_PIPE.UNPACK_MESSAGE(message);
  ELSE
    DBMS_OUTPUT.PUT_LINE('Blad');
    message := TO_CHAR(success);
  END IF;

  DBMS_OUTPUT.PUT_LINE('Komunikat ['||message||']');

END;
/
