/*
 * create_nds8.sql
 * Rozdzia 11., Oracle Database 11g. Programowanie w jzyku PL/SQL
 * Michael McLaughlin
 *
 * UWAGI:
 *
 * Ten skrypt NDS uywa miejsc na dane i zmiennych powizanych do
 * wczytywania i zapisywania wartoci w instrukcji zgodnej z metod 4. pakietu DBMS_SQL.
 */

-- Uywane do diagnozowania skryptu.
SET ECHO ON
SET FEEDBACK ON
SET PAGESIZE 49999
SET SERVEROUTPUT ON SIZE 1000000

DECLARE
  -- Jawna deklaracja struktury rekordowej i tabeli takich struktur.
  TYPE title_record IS RECORD
  ( item_title     VARCHAR2(60)
  , item_subtitle  VARCHAR2(60));
  TYPE title_table IS TABLE OF title_record;
  -- Deklaracje zmiennych na potrzeby instrukcji dynamicznej.
  title_cursor  SYS_REFCURSOR;
  title_rows    TITLE_TABLE;
  -- Deklaracje zmiennych na potrzeby pakietu DBMS_SQL.
  c             INTEGER := dbms_sql.open_cursor;
  fdbk          INTEGER;
  -- Deklaracje zmiennych lokalnych.
  counter       NUMBER := 1;
  column_names  DBMS_SQL.VARCHAR2_TABLE;
  item_ids      DBMS_SQL.NUMBER_TABLE;
  stmt          VARCHAR2(2000);
  substmt       VARCHAR2(2000) := '';
BEGIN
  -- Wyszukiwanie wierszy speniajcych okrelone kryteria.
  FOR i IN (SELECT 'item_ids' AS column_names
            ,       item_id
            FROM    item
            WHERE   REGEXP_LIKE(item_title,'^Harry Potter')) LOOP
    column_names(counter) := counter;
    item_ids(counter) := i.item_id;
    counter := counter + 1;
  END LOOP;
 
  dbms_sql.close_cursor(c);
  -- Dynamiczne tworzenie podzapytania.
  IF item_ids.COUNT = 1 THEN
    substmt := 'WHERE item_id IN (:item_ids)';
  ELSE
    substmt := 'WHERE item_id IN (';
    FOR i IN 1..item_ids.COUNT LOOP
      IF i = 1 THEN
        substmt := substmt ||':'||i;
      ELSE
        substmt := substmt ||',:'||i;
      END IF;
    END LOOP;
    substmt := substmt || ')';
  END IF;

  -- Przygotowanie instrukcji.
  stmt := 'SELECT  item_title, item_subtitle '
       || 'FROM    item '
       ||  substmt;
       
  -- Przetwarzanie instrukcji przy uyciu pakietu DBMS_SQL.
  dbms_sql.parse(c,stmt,dbms_sql.native);

  -- Wizanie zmiennych okrelajcych nazw i warto.  
  FOR i IN 1..item_ids.COUNT LOOP
    dbms_sql.bind_variable(c,column_names(i),item_ids(i));
  END LOOP;

  -- Wykonanie instrukcji przy uyciu pakietu DBMS_SQL.  
  fdbk := dbms_sql.execute(c);  

  -- Przeksztacanie kursora na potrzeby instrukcji NDS.
  title_cursor := dbms_sql.to_refcursor(c);  

  -- Otwarcie i wczytanie kursora dynamicznego oraz zamknicie go.
  FETCH title_cursor BULK COLLECT INTO title_rows;
  FOR i IN 1..title_rows.COUNT LOOP
    dbms_output.put_line(
      '['||title_rows(i).item_title||']['||title_rows(i).item_subtitle||']');
  END LOOP;

  -- Zamknicie systemowego kursora referencyjnego.         
  CLOSE title_cursor;
END;
/

