/*
 * create_dbms_sql1.sql
 * Rozdzia 11., Oracle Database 11g. Programowanie w jzyku PL/SQL
 * Michael McLaughlin
 *
 * UWAGI:
 *
 * Ten skrypt uywa pakietu DBMS_SQL do warunkowego usunicia tabeli.
 */

-- Uywane do diagnozowania skryptu.
SET ECHO ON
SET FEEDBACK ON
SET PAGESIZE 49999
SET SERVEROUTPUT ON SIZE 1000000

DECLARE
  -- Definicje zmiennych lokalnych na potrzeby pakietu DBMS_SQL.
  c         INTEGER := dbms_sql.open_cursor;
  fdbk      INTEGER;
  stmt      VARCHAR2(2000);

BEGIN
  -- Sprawdzanie w ptli, czy naley usun sekwencj.
  FOR i IN (SELECT null
            FROM   user_objects
            WHERE  object_name = 'SAMPLE_SEQUENCE') LOOP

    -- Tworzenie dynamicznej instrukcji SQL.
    stmt := 'DROP SEQUENCE sample_sequence';

    -- Przetwarzanie i wykonywanie instrukcji.
    dbms_sql.parse(c,stmt,dbms_sql.native);
    fdbk := dbms_sql.execute(c);

    -- Zamknicie otwartego kursora.
    dbms_sql.close_cursor(c);

    -- Wywietlenie danych wyjciowych.
    dbms_output.put_line('Usunito sekwencj [SAMPLE_SEQUENCE]');
  END LOOP;
END;
/