/*
 * load_web_clob_loading.sql
 * Rozdzia 8., Oracle Database 11g. Programowanie w jzyku PL/SQL
 * Michael McLaughlin
 *
 * Ten skrypt tworzy procedur zapewniajc dostp do danych typu CLOB z
 * tabeli ITEM.
 */

CREATE OR REPLACE PROCEDURE web_load_clob_from_file  
( item_id_in IN     NUMBER
, descriptor IN OUT CLOB ) IS

BEGIN

  -- Uycie klauzuli FOR UPDATE spowoduje utworzenie transakcji DML.
  UPDATE    item
  SET       item_desc = empty_clob()
  WHERE     item_id = item_id_in
  RETURNING item_desc INTO descriptor;
       
END web_load_clob_from_file;
/

