<?php
  /*  ReadCanonicalFileToImage.php
   *  Rozdzia 8., Oracle Database 11g. Programowanie w jzyku PL/SQL
   *  Michael McLaughlin
   *
   *  Ten skrypt pobiera rysunek z kolumny typu BLOB i
   *  przeksztaca go na obraz w formacie PNG.
   *
   *  UWAGI:
   *
   *  Nagwek musi znale si w znaczniku PHP, poniewa nie mona
   *  wywietli obrazu przed wywoaniem funkcji header(), ktra informuje,
   *  e rysunek ma format PNG.
   */

  // Sprawdza moliwo nawizania poczenia z baz danych.
  if ($c = @oci_new_connect("plsql","plsql","orcl"))  {

    // Deklaracja zmiennych wejciowych.
    (isset($_GET['id']))    ? $id = $_GET['id'] : $id = 1021;

    // Deklaracja instrukcji SELECT jzyka SQL zwracajcej dane typu CLOB.
    $stmt = "SELECT get_canonical_bfilename('ITEM','ITEM_PHOTO','ITEM_ID',:id)
             FROM   dual";

    // Przetwarzanie zapytania przy uyciu poczenia.
    $s = oci_parse($c,$stmt);

    // Wizanie zmiennych jzyka PHP z typami biblioteki OCI.
    oci_bind_by_name($s,':id',$id);

    // Wykonywanie instrukcji jzyka PL/SQL.
    if (oci_execute($s))  {

      // Zwracanie deskryptora typu LOB i zwalnianie zasobw.
      while (oci_fetch($s))
      {
        for ($i = 1;$i <= oci_num_fields($s);$i++)
          if ((!is_object(oci_result($s,$i))) && (!oci_field_is_null($s,$i)))
            $data = oci_result($s,$i);
          else
            $data = "&nbsp;";
      }


      // Najpierw wywietlanie nagwka.
      header('Content-type: image/png');
      imagepng(imagecreatefromstring(file_get_contents($data)));

    }

    // Zamknicie poczenia z baz danych.
    oci_close($c);
  }
  else
  {
    // Przypisanie bdu OCI i formatowanie cudzysoww oraz apostrofw.
    $errorMessage = oci_error();
    print htmlentities($errorMessage['message'])."<br />";
  }
?>