/*
 * create_varray3.sql
 * Rozdzia 7., Oracle Database 11g. Programowanie w jzyku PL/SQL
 * Michael McLaughlin
 *
 * UWAGI:
 *
 * Ten skrypt tworzy tablice VARRAY i ilustruje korzystanie z nich.
 */

-- Uywane do diagnozowania skryptu.
SET ECHO ON
SET FEEDBACK ON
SET PAGESIZE 49999
SET SERVEROUTPUT ON SIZE 1000000

CREATE OR REPLACE TYPE integer_varray AS VARRAY(3) OF INTEGER;
/

DECLARE
  varray_integer INTEGER_VARRAY := integer_varray(NULL,NULL,NULL);
BEGIN
  -- Przypisanie okrelonych wartoci w celu zastpienia wartoci null.
  FOR i IN 1..3 LOOP
    varray_integer(i) := 10 + i;
  END LOOP;

  -- Wywietlenie zainicjowanych wartoci.
  dbms_output.put_line('Tablica VARRAY zainicjowana za pomoc wartoci.');
  dbms_output.put_line('-----------------------------------------------');
  FOR i IN 1..3 LOOP
    -- Wywietlenie zawartoci
    dbms_output.put     ('Tablica VARRAY liczb cakowitych ['||i||'] ');
    dbms_output.put_line('['||varray_integer(i)||']');
  END LOOP;
END;
/

