/*
 * create_varray2.sql
 * Rozdzia 7., Oracle Database 11g. Programowanie w jzyku PL/SQL
 * Michael McLaughlin
 *
 * UWAGI:
 *
 * Ten skrypt tworzy tablice VARRAY i ilustruje korzystanie z nich.
 */

-- Uywane do diagnozowania skryptu.
SET ECHO ON
SET FEEDBACK ON
SET PAGESIZE 49999
SET SERVEROUTPUT ON SIZE 1000000

DECLARE
  -- Definicja tablicy VARRAY o trzech wierszach przechowujcej liczby cakowite.
  TYPE integer_varray IS VARRAY(3) OF INTEGER;

  -- Deklarowanie i inicjowanie pustego zbioru wierszy.
  varray_integer INTEGER_VARRAY := integer_varray();
BEGIN
  -- Przydzia pamici przy powikszaniu wartoci indeksu. 
  FOR i IN 1..3 LOOP
    varray_integer.EXTEND;        -- Przydzia pamici na elementy kolekcji.
    varray_integer(i) := 10 + i;  -- Przypisywanie wartoci do elementw z indeksami.
  END LOOP;

  -- Wywietlanie nagwka
  dbms_output.put_line('Tablica VARRAY zainicjowana za pomoc wartoci.');
  dbms_output.put_line('------------------------------------------------');
  -- Przejcie w ptli po rekordach i wywietlenie wartoci
  FOR i IN 1..3 LOOP
    dbms_output.put     ('Tablica VARRAY liczb cakowitych ['||i||'] ');
    dbms_output.put_line('['||varray_integer(i)||']');
  END LOOP;
END;
/

