/*
 * create_nestedtable2.sql
 * Rozdzia 7., Oracle Database 11g. Programowanie w jzyku PL/SQL
 * Michael McLaughlin
 *
 * UWAGI:
 *
 * Ten skrypt tworzy tablice zagniedone i ilustruje korzystanie z nich.
 */

-- Uywane do diagnozowania skryptu.
SET ECHO ON
SET FEEDBACK ON
SET PAGESIZE 49999
SET SERVEROUTPUT ON SIZE 1000000

DECLARE
  -- Definicja tabeli zagniedonej.
  TYPE card_suit IS TABLE OF VARCHAR2(5 CHAR);

  -- Deklarowanie i inicjowanie przy uyciu pustego zbioru wierszy
  cards CARD_SUIT := card_suit();
BEGIN
  -- Przydzia pamici przy powikszaniu wartoci indeksu.
  FOR i IN 1..3 LOOP
    cards.EXTEND;
    IF    i = 1 THEN
      cards(i) := 'As';
    ELSIF i = 2 THEN
      cards(i) := 'Dwjka';
    ELSIF i = 3 THEN
      cards(i) := 'Trjka';
    END IF;
  END LOOP;

  -- Wywietlanie zainicjowanej kolekcji.
  dbms_output.put_line('Tabela zagniedona zainicjowana asem, dwjk i trjk.');
  dbms_output.put_line('--------------------------------------------------------');
  FOR i IN 1..3 LOOP
    dbms_output.put     ('Tabela cards ['||i||'] ');
    dbms_output.put_line('['||cards(i)||']');
  END LOOP;
END;
/

