/*
 * create_assocarray6.sql
 * Rozdzia 7., Oracle Database 11g. Programowanie w jzyku PL/SQL
 * Michael McLaughlin
 *
 * UWAGI:
 *
 * Ten skrypt tworzy tablice asocjacyjne i ilustruje korzystanie z nich.
 */

-- Uywane do diagnozowania skryptu.
SET ECHO ON
SET FEEDBACK ON
SET PAGESIZE 49999
SET SERVEROUTPUT ON SIZE 1000000

DECLARE
  -- Definicje zmiennych sucych do poruszania si po tablicy asocjacyjnej
  -- o indeksach w postaci acuchw znakw o zmiennej dugoci
  current VARCHAR2(11 CHAR);
  element INTEGER;

  -- Definicja tablicy VARRAY o 12 acuchach znakw o zmiennej dugoci 
  TYPE months_varray IS VARRAY(12) OF STRING(11 CHAR);
   
  -- Definicja tablicy asocjacyjnej acuchw znakw o zmiennej dugoci 
  TYPE calendar_table IS TABLE OF VARCHAR2(11 CHAR) INDEX BY VARCHAR2(11 CHAR);

  -- Deklaracja i tworzenie tablicy VARRAY 
  month MONTHS_VARRAY := 
    months_varray('Stycze','Luty','Marzec','Kwiecie','Maj','Czerwiec','Lipiec'
                 ,'Sierpie','Wrzesie','Padziernik','Listopad','Grudzie');

  -- Deklaracja pustej zmiennej typu tablicy asocjacyjnej 
  calendar CALENDAR_TABLE;
BEGIN
  -- Sprawdzenie, czy tablica calendar nie ma elementw 
  IF calendar.COUNT = 0 THEN
    -- Wywietlenie nagwka
    DBMS_OUTPUT.PUT_LINE('Ptla z przypisaniem:');
    DBMS_OUTPUT.PUT_LINE('---------------------');
    FOR i IN month.FIRST..month.LAST LOOP
      calendar(month(i)) := TO_CHAR(i);
      DBMS_OUTPUT.PUT_LINE('Element ['||month(i)||'] ma warto ['||i||']');
    END LOOP;

    -- Wywietlenie nagwka
    DBMS_OUTPUT.PUT(CHR(10));
    DBMS_OUTPUT.PUT_LINE('Ptla po przypisaniu:');
    DBMS_OUTPUT.PUT_LINE('---------------------');
    FOR i IN 1..calendar.COUNT LOOP
      -- Sprawdzenie, czy jest to pierwszy element w ptli. 
      IF i = 1 THEN
        -- Przypisanie pierwszego indeksu znakowego do zmiennej. 
        current := calendar.FIRST;
        -- Uycie otrzymanego indeksu do znalezienia nastpnego. 
        element := calendar(current);
      ELSE
        -- Sprawdzenie, czy nastpny indeks istnieje. 
        IF calendar.NEXT(current) IS NOT NULL THEN
          -- Przypisanie indeksu znakowego do zmiennej. 
          current := calendar.NEXT(current);
          -- Uycie otrzymanego indeksu do znalezienia nastpnego.
          element := calendar(current);
        ELSE
          -- Wyjcie z ptli, poniewa ostatni indeks zosta ju wczytany 
          EXIT;
        END IF;
      END IF;

      -- Wywietlenie indeksowanych elementw tablicy asocjacyjnej 
      DBMS_OUTPUT.PUT_LINE(
        'Element ['||current||'] ma warto ['||element||']');
    END LOOP;
  END IF;
END;
/
