/*
 * create_assocarray5.sql
 * Rozdzia 7., Oracle Database 11g. Programowanie w jzyku PL/SQL
 * Michael McLaughlin
 *
 * UWAGI:
 *
 * Ten skrypt tworzy tablice asocjacyjne i ilustruje korzystanie z nich.
 */

-- Uywane do diagnozowania skryptu.
SET ECHO ON
SET FEEDBACK ON
SET PAGESIZE 49999
SET SERVEROUTPUT ON SIZE 1000000

DECLARE
  -- Definicja tablicy VARRAY zawierajcej 12 acuchw znakw 
  TYPE months_varray IS VARRAY(12) OF STRING(11 CHAR);
   
  -- Definicja tablicy asocjacyjnej acuchw znakw 
  TYPE calendar_table IS TABLE OF VARCHAR2(11 CHAR)
    INDEX BY BINARY_INTEGER;

  -- Deklaracja i utworzenie tablicy VARRAY 
  month MONTHS_VARRAY := 
    months_varray('Stycze','Luty','Marzec','Kwiecie','Maj','Czerwiec','Lipiec'
                 ,'Sierpie','Wrzesie','Padziernik','Listopad','Grudzie');

  -- Deklaracja zmiennej typu tablicy asocjacyjnej 
  calendar CALENDAR_TABLE;
BEGIN
  -- Sprawdzenie, czy kalendarz nie ma elementw
  IF calendar.COUNT = 0 THEN
    DBMS_OUTPUT.PUT_LINE('Ptla z przypisaniem:');
    DBMS_OUTPUT.PUT_LINE('---------------------');
    FOR i IN month.FIRST..month.LAST LOOP
      calendar(i) := '';
      DBMS_OUTPUT.PUT_LINE('Element ['||i||'] ma warto ['||calendar(i)||']');
      calendar(i) := month(i);
    END LOOP;

    -- Wywietlenie przypisanych wartoci elementw.
    DBMS_OUTPUT.PUT(CHR(10));
    DBMS_OUTPUT.PUT_LINE('Ptla po przypisaniu:');
    DBMS_OUTPUT.PUT_LINE('--------------------');
    FOR i IN calendar.FIRST..calendar.LAST LOOP
      DBMS_OUTPUT.PUT_LINE('Element ['||i||'] ma warto ['||calendar(i)||']');
    END LOOP;
  END IF;
END;
/

