/*
 * update.sql
 * Rozdzia 4., Oracle Database 11g. Programowanie w jzyku PL/SQL
 * Michael McLaughlin
 *
 * UWAGI:
 *
 * Ten skrypt ilustruje aktualizowanie danych.
 */

-- Uywane do diagnozowania skryptu.
SET ECHO ON
SET FEEDBACK ON
SET PAGESIZE 49999
SET SERVEROUTPUT ON SIZE 1000000

DECLARE
  TYPE id _collection IS TABLE OF NUMBER;
  TYPE title_collection IS TABLE OF VARCHAR2(60);
  id    ID_COLLECTION;
  title TITLE_COLLECTION;
  CURSOR c IS
    SELECT item_id
    ,      item_title
    FROM   item;
BEGIN
  OPEN c;
  LOOP
    FETCH c BULK COLLECT INTO id, title LIMIT 10;
    EXIT WHEN title.count = 0;
    FORALL i IN id.FIRST..id.LAST
      UPDATE item_temp
      SET    title = title(i)||': '
      WHERE  id = id(i);
  END LOOP;
END;
/






















