/*
 * explicit_cursor6.sql
 * Rozdzia 4., Oracle Database 11g. Programowanie w jzyku PL/SQL
 * Michael McLaughlin
 *
 * UWAGI:
 *
 * Ten skrypt ilustruje kursory jawne.
 */

-- Uywane do diagnozowania skryptu.
SET ECHO ON
SET FEEDBACK ON
SET PAGESIZE 49999
SET SERVEROUTPUT ON SIZE 1000000

DECLARE
  lowend  NUMBER;
  highend NUMBER;
  item_id number := 1012;
  TYPE item_record IS RECORD
  ( id    NUMBER
  , title VARCHAR2(60));
  item ITEM_RECORD;
  CURSOR c
  ( low_id  NUMBER
  , high_id NUMBER) IS
    SELECT item_id
    ,      item_title
    FROM   item
    WHERE  item_id BETWEEN low_id AND high_id;
BEGIN
  lowend  := TO_NUMBER(NVL(&1,1005));
  highend := TO_NUMBER(NVL(&2,1021));
  OPEN c (lowend,highend);
  LOOP
    FETCH c INTO item;
    EXIT WHEN c%NOTFOUND;
    dbms_output.put_line('Tytu ['||item.title||']');
  END LOOP;
END;
/

















