/*
 * explicit_cursor4.sql
 * Rozdzia 4., Oracle Database 11g. Programowanie w jzyku PL/SQL
 * Michael McLaughlin
 *
 * UWAGI:
 *
 * Ten skrypt ilustruje kursory jawne.
 */

-- Uywane do diagnozowania skryptu.
SET ECHO ON
SET FEEDBACK ON
SET PAGESIZE 49999
SET SERVEROUTPUT ON SIZE 1000000

DECLARE
  TYPE item_record IS RECORD
  (id      NUMBER
  , title  VARCHAR2(60));
  CURSOR c IS
    SELECT item_id
    ,      item_title
    FROM   item
    WHERE  item_id = -1;
BEGIN
  OPEN c;
  LOOP
    FETCH c INTO item;
    IF c%NOTFOUND THEN
      IF c%ROWCOUNT = 0 THEN
        dbms_output.put_line('Danych nie znaleziono.');
      END IF;
      EXIT;
    ELSE
      dbms_output.put_line('Tytu ['||item.title||']');
    END IF;
  END LOOP;
END;
/















